/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.List;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.metadata.BundleItem;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.runner.ContentItemFilter;

public abstract class ModificationBuilderTarget<T> {
    private ContentItemFilter itemFilter;

    protected ModificationBuilderTarget() {
        this(ContentItemFilter.ALL);
    }

    protected ModificationBuilderTarget(ContentItemFilter itemFilter) {
        this.itemFilter = itemFilter;
    }

    protected abstract T internalAddModification(ContentModification var1);

    protected abstract T returnThis();

    public T addContentModification(ContentModification modification) {
        if (this.itemFilter.accepts(modification.getItem())) {
            this.internalAddModification(modification);
        }
        return this.returnThis();
    }

    public T addBundle(String moduleName, String slot, byte[] newHash) {
        ModuleItem item = this.createBundleItem(moduleName, slot, newHash);
        this.addContentModification(this.createContentModification(item, ModificationType.ADD, IoUtils.NO_CONTENT));
        return this.returnThis();
    }

    public T modifyBundle(String moduleName, String slot, byte[] existingHash, byte[] newHash) {
        ModuleItem item = this.createBundleItem(moduleName, slot, newHash);
        this.addContentModification(this.createContentModification(item, ModificationType.MODIFY, existingHash));
        return this.returnThis();
    }

    public T removeBundle(String moduleName, String slot, byte[] existingHash) {
        ModuleItem item = this.createBundleItem(moduleName, slot, IoUtils.NO_CONTENT);
        this.addContentModification(this.createContentModification(item, ModificationType.REMOVE, existingHash));
        return this.returnThis();
    }

    public T addFile(String name, List<String> path, byte[] newHash, boolean isDirectory) {
        MiscContentItem item = this.createMiscItem(name, path, newHash, isDirectory);
        this.addContentModification(this.createContentModification(item, ModificationType.ADD, IoUtils.NO_CONTENT));
        return this.returnThis();
    }

    public T modifyFile(String name, List<String> path, byte[] existingHash, byte[] newHash, boolean isDirectory) {
        MiscContentItem item = this.createMiscItem(name, path, newHash, isDirectory);
        this.addContentModification(this.createContentModification(item, ModificationType.MODIFY, existingHash));
        return this.returnThis();
    }

    public T removeFile(String name, List<String> path, byte[] existingHash, boolean isDirectory) {
        MiscContentItem item = this.createMiscItem(name, path, IoUtils.NO_CONTENT, isDirectory);
        this.addContentModification(this.createContentModification(item, ModificationType.REMOVE, existingHash));
        return this.returnThis();
    }

    public T addModule(String moduleName, String slot, byte[] newHash) {
        ModuleItem item = this.createModuleItem(moduleName, slot, newHash);
        this.addContentModification(this.createContentModification(item, ModificationType.ADD, IoUtils.NO_CONTENT));
        return this.returnThis();
    }

    public T modifyModule(String moduleName, String slot, byte[] existingHash, byte[] newHash) {
        ModuleItem item = this.createModuleItem(moduleName, slot, newHash);
        this.addContentModification(this.createContentModification(item, ModificationType.MODIFY, existingHash));
        return this.returnThis();
    }

    public T removeModule(String moduleName, String slot, byte[] existingHash) {
        ModuleItem item = this.createModuleItem(moduleName, slot, IoUtils.NO_CONTENT);
        this.addContentModification(this.createContentModification(item, ModificationType.REMOVE, existingHash));
        return this.returnThis();
    }

    public void setContentItemFilter(ContentItemFilter filter) {
        this.itemFilter = filter;
    }

    protected ContentModification createContentModification(ContentItem item, ModificationType type, byte[] existingHash) {
        return new ContentModification(item, existingHash, type);
    }

    protected MiscContentItem createMiscItem(String name, List<String> path, byte[] newHash, boolean isDirectory) {
        return new MiscContentItem(name, path, newHash, isDirectory);
    }

    protected ModuleItem createBundleItem(String moduleName, String slot, byte[] hash) {
        return new BundleItem(moduleName, slot, hash);
    }

    protected ModuleItem createModuleItem(String moduleName, String slot, byte[] hash) {
        return new ModuleItem(moduleName, slot, hash);
    }
}

