/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.validation.GeneralValidatorImpl;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;

public class AbstractValidatorContextResolver {
    private static final Logger logger = Logger.getLogger(AbstractValidatorContextResolver.class);
    private volatile ValidatorFactory validatorFactory;
    static final Object RD_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValidatorFactory getValidatorFactory() {
        ValidatorFactory tmpValidatorFactory = this.validatorFactory;
        if (tmpValidatorFactory == null) {
            Object object = RD_LOCK;
            synchronized (object) {
                tmpValidatorFactory = this.validatorFactory;
                if (tmpValidatorFactory == null) {
                    try {
                        InitialContext context = new InitialContext();
                        this.validatorFactory = tmpValidatorFactory = (ValidatorFactory)ValidatorFactory.class.cast(context.lookup("java:comp/ValidatorFactory"));
                        logger.debug("Using CDI supporting " + this.validatorFactory);
                    }
                    catch (NamingException e) {
                        logger.info("Unable to find CDI supporting ValidatorFactory. Using default ValidatorFactory");
                        HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
                        this.validatorFactory = tmpValidatorFactory = config.buildValidatorFactory();
                    }
                }
            }
        }
        return this.validatorFactory;
    }

    public GeneralValidatorCDI getContext(Class<?> type) {
        try {
            Configuration config = Validation.byDefaultProvider().configure();
            BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
            boolean isExecutableValidationEnabled = bootstrapConfiguration.isExecutableValidationEnabled();
            Set defaultValidatedExecutableTypes = bootstrapConfiguration.getDefaultValidatedExecutableTypes();
            return new GeneralValidatorImpl(this.getValidatorFactory(), isExecutableValidationEnabled, defaultValidatedExecutableTypes);
        }
        catch (Exception e) {
            throw new ValidationException("Unable to load Validation support", (Throwable)e);
        }
    }
}

