/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.undertow.AjpListenerResourceDefinition;
import org.wildfly.extension.undertow.AjpListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.xnio.OptionMap;

class AjpListenerAdd
extends ListenerAdd {
    AjpListenerAdd(AjpListenerResourceDefinition def) {
        super(def);
    }

    @Override
    ListenerService<? extends ListenerService> createService(String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions, OptionMap socketOptions) throws OperationFailedException {
        ModelNode schemeNode = AjpListenerResourceDefinition.SCHEME.resolveModelAttribute(context, model);
        String scheme = null;
        if (schemeNode.isDefined()) {
            scheme = schemeNode.asString();
        }
        return new AjpListenerService(name, scheme, listenerOptions, socketOptions);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, ServiceBuilder<? extends ListenerService> serviceBuilder, ModelNode model, ListenerService service) throws OperationFailedException {
        String redirectBindingRef = ListenerResourceDefinition.REDIRECT_SOCKET.resolveModelAttribute(context, model).asString();
        serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{redirectBindingRef}), SocketBinding.class, service.getRedirectSocket());
    }
}

