/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.BufferCacheDefinition;
import org.wildfly.extension.undertow.BufferCacheService;

final class BufferCacheAdd
extends AbstractAddStepHandler {
    static final BufferCacheAdd INSTANCE = new BufferCacheAdd();

    BufferCacheAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : BufferCacheDefinition.INSTANCE.getAttributes()) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        int bufferSize = BufferCacheDefinition.BUFFER_SIZE.resolveModelAttribute(context, model).asInt();
        int buffersPerRegions = BufferCacheDefinition.BUFFERS_PER_REGION.resolveModelAttribute(context, model).asInt();
        int maxRegions = BufferCacheDefinition.MAX_REGIONS.resolveModelAttribute(context, model).asInt();
        BufferCacheService service = new BufferCacheService(bufferSize, buffersPerRegions, maxRegions);
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder builder = target.addService(BufferCacheService.SERVICE_NAME.append(new String[]{name}), (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.addListener((ServiceListener)verificationHandler);
        ServiceController serviceController = builder.install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
    }
}

