/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.Account;
import java.util.HashMap;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;

public class AuditNotificationReceiver
implements NotificationReceiver {
    private final AuditManager auditManager;

    public AuditNotificationReceiver(AuditManager auditManager) {
        this.auditManager = auditManager;
    }

    public void handleNotification(SecurityNotification notification) {
        SecurityNotification.EventType event = notification.getEventType();
        if (event == SecurityNotification.EventType.AUTHENTICATED || event == SecurityNotification.EventType.FAILED_AUTHENTICATION) {
            AuditEvent auditEvent = new AuditEvent(event == SecurityNotification.EventType.AUTHENTICATED ? "Success" : "Failure");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            Account account = notification.getAccount();
            if (account != null) {
                ctxMap.put("principal", account.getPrincipal().getName());
            }
            ctxMap.put("message", notification.getMessage());
            ctxMap.put("Source", this.getClass().getCanonicalName());
            auditEvent.setContextMap(ctxMap);
            this.auditManager.audit(auditEvent);
        }
    }
}

