/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.jsapi.JSAPIWriter;
import org.jboss.resteasy.jsapi.ServiceRegistry;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JSAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = -1985015444704126795L;
    private static final Logger logger = Logger.getLogger(JSAPIServlet.class);
    private Map<String, ServiceRegistry> services;
    private JSAPIWriter apiWriter = new JSAPIWriter();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (logger.isDebugEnabled()) {
            logger.info("Loading JSAPI Servlet");
        }
        this.scanResources();
        if (logger.isDebugEnabled()) {
            logger.debug("JSAPIServlet loaded");
        }
        ServletContext servletContext = config.getServletContext();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURL().toString();
        uri = uri.substring(0, uri.length() - req.getServletPath().length());
        if (logger.isDebugEnabled()) {
            logger.debug("Serving " + pathInfo);
            logger.debug("Query " + req.getQueryString());
        }
        if (this.services == null) {
            this.scanResources();
        }
        if (this.services == null) {
            resp.sendError(503, "There are no Resteasy deployments initialized yet to scan from.  Either set the load-on-startup on each Resteasy servlet, or, if in an EE environment like JBoss or Wildfly, you'll have to do an invocation on each of your REST services to get the servlet loaded.");
        }
        this.apiWriter.writeJavaScript(uri, req, resp, this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanResources() {
        ServletConfig config = this.getServletConfig();
        ServletContext servletContext = config.getServletContext();
        Map deployments = (Map)servletContext.getAttribute("resteasy.deployments");
        if (deployments == null) {
            return;
        }
        JSAPIServlet jSAPIServlet = this;
        synchronized (jSAPIServlet) {
            this.services = new HashMap<String, ServiceRegistry>();
            for (Map.Entry entry : deployments.entrySet()) {
                ResourceMethodRegistry registry = (ResourceMethodRegistry)((ResteasyDeployment)entry.getValue()).getRegistry();
                ResteasyProviderFactory providerFactory = ((ResteasyDeployment)entry.getValue()).getProviderFactory();
                ServiceRegistry service = new ServiceRegistry(null, registry, providerFactory, null);
                this.services.put((String)entry.getKey(), service);
            }
        }
    }
}

