/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AccessControlListHandler
implements HttpHandler {
    private volatile HttpHandler next;
    private volatile boolean defaultAllow = false;
    private final ExchangeAttribute attribute;
    private final List<AclMatch> acl = new CopyOnWriteArrayList<AclMatch>();

    public AccessControlListHandler(HttpHandler next, ExchangeAttribute attribute) {
        this.next = next;
        this.attribute = attribute;
    }

    public AccessControlListHandler(ExchangeAttribute attribute) {
        this.attribute = attribute;
        this.next = ResponseCodeHandler.HANDLE_404;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String attribute = this.attribute.readAttribute(exchange);
        if (this.isAllowed(attribute)) {
            this.next.handleRequest(exchange);
        } else {
            exchange.setResponseCode(403);
            exchange.endExchange();
        }
    }

    boolean isAllowed(String attribute) {
        if (attribute != null) {
            for (AclMatch rule : this.acl) {
                if (!rule.matches(attribute)) continue;
                return !rule.isDeny();
            }
        }
        return this.defaultAllow;
    }

    public boolean isDefaultAllow() {
        return this.defaultAllow;
    }

    public AccessControlListHandler setDefaultAllow(boolean defaultAllow) {
        this.defaultAllow = defaultAllow;
        return this;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public AccessControlListHandler setNext(HttpHandler next) {
        this.next = next;
        return this;
    }

    public AccessControlListHandler addAllow(String pattern) {
        return this.addRule(pattern, false);
    }

    public AccessControlListHandler addDeny(String pattern) {
        return this.addRule(pattern, true);
    }

    public AccessControlListHandler clearRules() {
        this.acl.clear();
        return this;
    }

    private AccessControlListHandler addRule(String userAgent, boolean deny) {
        this.acl.add(new AclMatch(deny, userAgent));
        return this;
    }

    static class AclMatch {
        private final boolean deny;
        private final Pattern pattern;

        protected AclMatch(boolean deny, String pattern) {
            this.deny = deny;
            this.pattern = this.createPattern(pattern);
        }

        private Pattern createPattern(String pattern) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw UndertowMessages.MESSAGES.notAValidRegularExpressionPattern(pattern);
            }
        }

        boolean matches(String attribute) {
            return this.pattern.matcher(attribute).matches();
        }

        boolean isDeny() {
            return this.deny;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "deny=" + this.deny + ", pattern='" + this.pattern + '\'' + '}';
        }
    }
}

