/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager;

import java.util.concurrent.Executor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.tx.jbossts.XATerminatorImpl;
import org.jboss.jca.core.workmanager.WorkManagerCoordinator;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.tm.JBossXATerminator;

public final class WorkManagerService
implements Service<WorkManager> {
    private final WorkManager value;
    private final InjectedValue<Executor> executorShort = new InjectedValue();
    private final InjectedValue<Executor> executorLong = new InjectedValue();
    private final InjectedValue<JBossXATerminator> xaTerminator = new InjectedValue();

    public WorkManagerService(WorkManager value) {
        ConnectorLogger.ROOT_LOGGER.debugf("Building WorkManager", new Object[0]);
        this.value = value;
    }

    public WorkManager getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("Starting JCA WorkManager: ", this.value.getName());
        BlockingExecutor longRunning = (BlockingExecutor)this.executorLong.getOptionalValue();
        if (longRunning != null) {
            this.value.setLongRunningThreadPool(longRunning);
            this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        } else {
            this.value.setLongRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
            this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        }
        this.value.setXATerminator((XATerminator)new XATerminatorImpl((JBossXATerminator)this.xaTerminator.getValue()));
        if (this.value.getName().equals("default")) {
            WorkManagerCoordinator.getInstance().setDefaultWorkManager(this.value);
        } else {
            WorkManagerCoordinator.getInstance().registerWorkManager(this.value);
        }
        if (this.value.isShutdown()) {
            this.value.cancelShutdown();
        }
        ConnectorLogger.ROOT_LOGGER.debugf("Started JCA WorkManager: ", this.value.getName());
    }

    public void stop(StopContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("Stopping JCA WorkManager: ", this.value.getName());
        this.value.shutdown();
        if (this.value.getName().equals("default")) {
            WorkManagerCoordinator.getInstance().setDefaultWorkManager(null);
        } else {
            WorkManagerCoordinator.getInstance().unregisterWorkManager(this.value);
        }
        ConnectorLogger.ROOT_LOGGER.debugf("Stopped JCA WorkManager: ", this.value.getName());
    }

    public Injector<Executor> getExecutorShortInjector() {
        return this.executorShort;
    }

    public Injector<Executor> getExecutorLongInjector() {
        return this.executorLong;
    }

    public Injector<JBossXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }
}

