/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ConnectionFactoryWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final ConnectionFactoryWriteAttributeHandler INSTANCE = new ConnectionFactoryWriteAttributeHandler();

    private ConnectionFactoryWriteAttributeHandler() {
        super(ConnectionFactoryDefinition.ATTRIBUTES);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AlternativeAttributeCheckHandler(ConnectionFactoryDefinition.ATTRIBUTES), OperationContext.Stage.MODEL);
        super.execute(context, operation);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ServiceName hqServiceName;
        AttributeDefinition attr = this.getAttributeDefinition(attributeName);
        if (attr.getFlags().contains(AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService == null) {
            return false;
        }
        if (hqService.getState() != ServiceController.State.UP) {
            return true;
        }
        if (!HornetQActivationService.isHornetQServerActive(context, operation)) {
            return false;
        }
        this.applyOperationToHornetQService(context, this.getName(operation), attributeName, newValue, hqService);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null && hqService.getState() == ServiceController.State.UP) {
            this.applyOperationToHornetQService(context, this.getName(operation), attributeName, valueToRestore, hqService);
        }
    }

    private String getName(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
    }

    private void applyOperationToHornetQService(OperationContext context, String name, String attributeName, ModelNode value, ServiceController<?> hqService) {
        block34: {
            if (attributeName.equals(ConnectionFactoryAttributes.Common.CONNECTOR.getName()) || attributeName.equals(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName())) {
                return;
            }
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            ConnectionFactoryControl control = (ConnectionFactoryControl)ConnectionFactoryControl.class.cast(server.getManagementService().getResource("jms.connectionfactory." + name));
            try {
                if (attributeName.equals(CommonAttributes.CLIENT_ID.getName())) {
                    control.setClientID(value.isDefined() ? value.asString() : null);
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES.getName())) {
                    control.setCompressLargeMessages(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD.getName())) {
                    control.setClientFailureCheckPeriod(value.asLong());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.CALL_TIMEOUT.getName())) {
                    control.setCallTimeout(value.asLong());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.CALL_FAILOVER_TIMEOUT.getName())) {
                    control.setCallFailoverTimeout(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE.getName())) {
                    control.setDupsOKBatchSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE.getName())) {
                    control.setConsumerMaxRate(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE.getName())) {
                    control.setConsumerWindowSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE.getName())) {
                    control.setProducerMaxRate(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE.getName())) {
                    control.setConfirmationWindowSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE.getName())) {
                    control.setBlockOnAcknowledge(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND.getName())) {
                    control.setBlockOnDurableSend(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND.getName())) {
                    control.setBlockOnNonDurableSend(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE.getName())) {
                    control.setPreAcknowledge(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONNECTION_TTL.getName())) {
                    control.setConnectionTTL(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE.getName())) {
                    control.setTransactionBatchSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.getName())) {
                    control.setMinLargeMessageSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.AUTO_GROUP.getName())) {
                    control.setAutoGroup(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.RETRY_INTERVAL.getName())) {
                    control.setRetryInterval(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER.getName())) {
                    control.setRetryIntervalMultiplier(value.asDouble());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS.getName())) {
                    control.setReconnectAttempts(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION.getName())) {
                    control.setFailoverOnInitialConnection(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE.getName())) {
                    control.setProducerWindowSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT.getName())) {
                    control.setCacheLargeMessagesClient(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.MAX_RETRY_INTERVAL.getName())) {
                    control.setMaxRetryInterval(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.SCHEDULED_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setScheduledThreadPoolMaxSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.THREAD_POOL_MAX_SIZE.getName())) {
                    control.setThreadPoolMaxSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.GROUP_ID.getName())) {
                    control.setGroupID(value.isDefined() ? value.asString() : null);
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS.getName())) {
                    control.setUseGlobalPools(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME.getName())) {
                    control.setConnectionLoadBalancingPolicyClassName(value.asString());
                    break block34;
                }
                throw MessagingMessages.MESSAGES.unsupportedRuntimeAttribute(attributeName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

