/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl.dataformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;

public class JournalCompleteRecordTX
extends JournalInternalRecord {
    private final TX_RECORD_TYPE txRecordType;
    private final long txID;
    private final EncodingSupport transactionData;
    private int numberOfRecords;

    public JournalCompleteRecordTX(TX_RECORD_TYPE isCommit, long txID, EncodingSupport transactionData) {
        this.txRecordType = isCommit;
        this.txID = txID;
        this.transactionData = transactionData;
    }

    @Override
    public void encode(HornetQBuffer buffer) {
        if (this.txRecordType == TX_RECORD_TYPE.COMMIT) {
            buffer.writeByte((byte)18);
        } else {
            buffer.writeByte((byte)17);
        }
        buffer.writeInt(this.fileID);
        buffer.writeByte(this.compactCount);
        buffer.writeLong(this.txID);
        buffer.writeInt(this.numberOfRecords);
        if (this.transactionData != null) {
            buffer.writeInt(this.transactionData.getEncodeSize());
        }
        if (this.transactionData != null) {
            this.transactionData.encode(buffer);
        }
        buffer.writeInt(this.getEncodeSize());
    }

    @Override
    public void setNumberOfRecords(int records) {
        this.numberOfRecords = records;
    }

    @Override
    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    @Override
    public int getEncodeSize() {
        if (this.txRecordType == TX_RECORD_TYPE.COMMIT) {
            return 22;
        }
        return 25 + (this.transactionData != null ? this.transactionData.getEncodeSize() : 0) + 1;
    }

    public static enum TX_RECORD_TYPE {
        COMMIT,
        PREPARE;

    }
}

