/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedQueuelessExecutorService;
import org.jboss.as.threads.ThreadsMessages;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EventListener;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.QueuelessExecutor;

public class QueuelessThreadPoolService
implements Service<ManagedQueuelessExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final InjectedValue<Executor> handoffExecutorValue = new InjectedValue();
    private ManagedQueuelessExecutorService executor;
    private int maxThreads;
    private boolean blocking;
    private TimeSpec keepAlive;

    public QueuelessThreadPoolService(int maxThreads, boolean blocking, TimeSpec keepAlive) {
        this.maxThreads = maxThreads;
        this.blocking = blocking;
        this.keepAlive = keepAlive;
    }

    public synchronized void start(StartContext context) throws StartException {
        TimeSpec keepAliveSpec = this.keepAlive;
        long keepAlive = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getUnit().toMillis(keepAliveSpec.getDuration());
        QueuelessExecutor queuelessExecutor = new QueuelessExecutor((ThreadFactory)this.threadFactoryValue.getValue(), JBossExecutors.directExecutor(), (Executor)this.handoffExecutorValue.getOptionalValue(), keepAlive);
        queuelessExecutor.setMaxThreads(this.maxThreads);
        queuelessExecutor.setBlocking(this.blocking);
        this.executor = new ManagedQueuelessExecutorService(queuelessExecutor);
    }

    public synchronized void stop(StopContext context) {
        ManagedQueuelessExecutorService executor = this.getValue();
        context.asynchronous();
        executor.internalShutdown();
        executor.addShutdownListener(new EventListener<StopContext>(){

            public void handleEvent(StopContext stopContext) {
                stopContext.complete();
            }
        }, context);
        this.executor = null;
    }

    public synchronized ManagedQueuelessExecutorService getValue() throws IllegalStateException {
        ManagedQueuelessExecutorService value = this.executor;
        if (value == null) {
            throw ThreadsMessages.MESSAGES.queuelessThreadPoolExecutorUninitialized();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public Injector<Executor> getHandoffExecutorInjector() {
        return this.handoffExecutorValue;
    }

    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        ManagedQueuelessExecutorService executor = this.executor;
        if (executor != null) {
            executor.setMaxThreads(maxThreads);
        }
    }

    public synchronized void setKeepAlive(TimeSpec keepAliveSpec) {
        this.keepAlive = keepAliveSpec;
        ManagedQueuelessExecutorService executor = this.executor;
        if (executor != null) {
            long keepAlive = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getDuration();
            executor.setKeepAlive(keepAlive);
        }
    }

    public int getCurrentThreadCount() {
        ManagedQueuelessExecutorService executor = this.getValue();
        return executor.getCurrentThreadCount();
    }

    public int getLargestThreadCount() {
        ManagedQueuelessExecutorService executor = this.getValue();
        return executor.getLargestThreadCount();
    }

    public int getRejectedCount() {
        ManagedQueuelessExecutorService executor = this.getValue();
        return executor.getRejectedCount();
    }

    public int getQueueSize() {
        return this.executor.getQueueSize();
    }

    TimeUnit getKeepAliveUnit() {
        return this.keepAlive == null ? TimeSpec.DEFAULT_KEEPALIVE.getUnit() : this.keepAlive.getUnit();
    }
}

