/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexOverlay;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IndexingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<IndexingConfiguration> {
    private static final Log log = LogFactory.getLog(IndexingConfigurationBuilder.class);
    private final AttributeSet attributes = IndexingConfiguration.attributeDefinitionSet();

    IndexingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Deprecated
    public IndexingConfigurationBuilder enable() {
        Attribute index = this.attributes.attribute(IndexingConfiguration.INDEX);
        if (index.get() == Index.NONE) {
            index.set((Object)Index.ALL);
        }
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder disable() {
        this.attributes.attribute(IndexingConfiguration.INDEX).set((Object)Index.NONE);
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder enabled(boolean enabled) {
        Attribute index = this.attributes.attribute(IndexingConfiguration.INDEX);
        if (index.get() == Index.NONE & enabled) {
            index.set((Object)Index.ALL);
        } else if (!enabled) {
            index.set((Object)Index.NONE);
        }
        return this;
    }

    boolean enabled() {
        return ((Index)((Object)this.attributes.attribute(IndexingConfiguration.INDEX).get())).isEnabled();
    }

    @Deprecated
    public IndexingConfigurationBuilder indexLocalOnly(boolean b) {
        if (b) {
            this.attributes.attribute(IndexingConfiguration.INDEX).set((Object)Index.LOCAL);
        }
        return this;
    }

    boolean indexLocalOnly() {
        return ((Index)((Object)this.attributes.attribute(IndexingConfiguration.INDEX).get())).isLocalOnly();
    }

    public IndexingConfigurationBuilder addProperty(String key, String value) {
        return this.setProperty(key, value);
    }

    public IndexingConfigurationBuilder setProperty(String key, Object value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.put((Object)key, value);
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)properties);
        return this;
    }

    public IndexingConfigurationBuilder withProperties(Properties props) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Properties)props));
        return this;
    }

    public IndexingConfigurationBuilder index(Index index) {
        this.attributes.attribute(IndexingConfiguration.INDEX).set((Object)index);
        return this;
    }

    public IndexingConfigurationBuilder autoConfig(boolean autoConfig) {
        this.attributes.attribute(IndexingConfiguration.AUTO_CONFIG).set((Object)autoConfig);
        return this;
    }

    public boolean autoConfig() {
        return (Boolean)this.attributes.attribute(IndexingConfiguration.AUTO_CONFIG).get();
    }

    public void validate() {
        if (this.enabled() && this.clustering().cacheMode().isInvalidation()) {
            throw log.invalidConfigurationIndexingWithInvalidation();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.enabled()) {
            try {
                String clazz = "org.infinispan.query.Search";
                Util.loadClassStrict((String)clazz, (ClassLoader)globalConfig.classLoader());
            }
            catch (ClassNotFoundException e) {
                throw log.invalidConfigurationIndexingWithoutModule();
            }
        }
    }

    public IndexingConfiguration create() {
        TypedProperties typedProperties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        if (this.autoConfig()) {
            if (this.clustering().cacheMode().isDistributed()) {
                IndexOverlay.DISTRIBUTED_INFINISPAN.apply(typedProperties);
            } else {
                IndexOverlay.NON_DISTRIBUTED_FS.apply(typedProperties);
            }
        }
        return new IndexingConfiguration(this.attributes.protect());
    }

    public IndexingConfigurationBuilder read(IndexingConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "IndexingConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

