/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class PersistenceConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<PersistenceConfiguration> {
    private List<StoreConfigurationBuilder<?, ?>> stores = new ArrayList(2);
    private final AttributeSet attributes = PersistenceConfiguration.attributeDefinitionSet();

    protected PersistenceConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public PersistenceConfigurationBuilder passivation(boolean b) {
        this.attributes.attribute(PersistenceConfiguration.PASSIVATION).set((Object)b);
        return this;
    }

    boolean passivation() {
        return (Boolean)this.attributes.attribute(PersistenceConfiguration.PASSIVATION).get();
    }

    public <T extends StoreConfigurationBuilder<?, ?>> T addStore(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(PersistenceConfigurationBuilder.class);
            StoreConfigurationBuilder builder = (StoreConfigurationBuilder)constructor.newInstance(this);
            this.stores.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate loader configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    public StoreConfigurationBuilder<?, ?> addStore(StoreConfigurationBuilder<?, ?> builder) {
        this.stores.add(builder);
        return builder;
    }

    public ClusterLoaderConfigurationBuilder addClusterLoader() {
        ClusterLoaderConfigurationBuilder builder = new ClusterLoaderConfigurationBuilder(this);
        this.stores.add(builder);
        return builder;
    }

    public SingleFileStoreConfigurationBuilder addSingleFileStore() {
        SingleFileStoreConfigurationBuilder builder = new SingleFileStoreConfigurationBuilder(this);
        this.stores.add(builder);
        return builder;
    }

    public PersistenceConfigurationBuilder clearStores() {
        this.stores.clear();
        return this;
    }

    public void validate() {
        int numFetchPersistentState = 0;
        for (StoreConfigurationBuilder<?, ?> b : this.stores) {
            b.validate();
            StoreConfiguration storeConfiguration = (StoreConfiguration)b.create();
            if (storeConfiguration.shared() && storeConfiguration.singletonStore().enabled()) {
                throw new CacheConfigurationException("Invalid cache loader configuration for " + storeConfiguration.getClass().getSimpleName() + "  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!");
            }
            if (!storeConfiguration.fetchPersistentState()) continue;
            ++numFetchPersistentState;
        }
        if (numFetchPersistentState > 1) {
            throw new CacheConfigurationException("Maximum one store can be set to 'fetchPersistentState'!");
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        for (StoreConfigurationBuilder<?, ?> b : this.stores) {
            b.validate(globalConfig);
        }
    }

    public PersistenceConfiguration create() {
        ArrayList<StoreConfiguration> stores = new ArrayList<StoreConfiguration>(this.stores.size());
        for (StoreConfigurationBuilder<?, ?> loader : this.stores) {
            stores.add((StoreConfiguration)loader.create());
        }
        return new PersistenceConfiguration(this.attributes.protect(), stores);
    }

    public PersistenceConfigurationBuilder read(PersistenceConfiguration template) {
        this.attributes.read(template.attributes());
        this.clearStores();
        for (StoreConfiguration c : template.stores()) {
            Class<CustomStoreConfigurationBuilder> builderClass = ConfigurationUtils.builderForNonStrict((Object)c);
            if (builderClass == null) {
                builderClass = CustomStoreConfigurationBuilder.class;
            }
            CustomStoreConfigurationBuilder builder = this.addStore(builderClass);
            builder.read(c);
        }
        return this;
    }

    public List<StoreConfigurationBuilder<?, ?>> stores() {
        return this.stores;
    }

    public String toString() {
        return "PersistenceConfigurationBuilder [stores=" + this.stores + ", attributes=" + this.attributes + "]";
    }
}

