/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;

public class SitesConfiguration {
    public static final AttributeDefinition<Boolean> DISABLE_BACKUPS = AttributeDefinition.builder((String)"disableBackups", (Object)false).immutable().build();
    public static final AttributeDefinition<Set<String>> IN_USE_BACKUP_SITES = AttributeDefinition.builder((String)"inUseBackupSites", null, Set.class).initializer((AttributeInitializer)new AttributeInitializer<Set<String>>(){

        public Set<String> initialize() {
            return new HashSet<String>(2);
        }
    }).immutable().build();
    private final BackupForConfiguration backupFor;
    private final List<BackupConfiguration> allBackups;
    private final Attribute<Boolean> disableBackups;
    private final Attribute<Set<String>> inUseBackupSites;
    private final AttributeSet attributes;

    static final AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SitesConfiguration.class, new AttributeDefinition[]{DISABLE_BACKUPS, IN_USE_BACKUP_SITES});
    }

    public SitesConfiguration(AttributeSet attributes, List<BackupConfiguration> allBackups, BackupForConfiguration backupFor) {
        this.attributes = attributes.checkProtection();
        this.allBackups = Collections.unmodifiableList(allBackups);
        this.disableBackups = attributes.attribute(DISABLE_BACKUPS);
        this.inUseBackupSites = attributes.attribute(IN_USE_BACKUP_SITES);
        this.backupFor = backupFor;
    }

    public boolean disableBackups() {
        return (Boolean)this.disableBackups.get();
    }

    public List<BackupConfiguration> allBackups() {
        return this.allBackups;
    }

    public List<BackupConfiguration> enabledBackups() {
        ArrayList<BackupConfiguration> result = new ArrayList<BackupConfiguration>();
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.enabled()) continue;
            result.add(bc);
        }
        return result;
    }

    public BackupForConfiguration backupFor() {
        return this.backupFor;
    }

    public BackupFailurePolicy getFailurePolicy(String siteName) {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.backupFailurePolicy();
        }
        throw new IllegalStateException("There must be a site configured for " + siteName);
    }

    public boolean hasInUseBackup(String siteName) {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.enabled();
        }
        return false;
    }

    public boolean hasEnabledBackups() {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.enabled()) continue;
            return true;
        }
        return false;
    }

    public Set<String> inUseBackupSites() {
        return (Set)this.inUseBackupSites.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.backupFor == null ? 0 : this.backupFor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SitesConfiguration other = (SitesConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes)) {
            return false;
        }
        return !(this.backupFor == null ? other.backupFor != null : !this.backupFor.equals(other.backupFor));
    }

    public String toString() {
        return "SitesConfiguration [backupFor=" + this.backupFor + ", attributes=" + this.attributes + "]";
    }
}

