/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PlatformMBeanServerLookup;

public class GlobalJmxStatisticsConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<String> JMX_DOMAIN = AttributeDefinition.builder((String)"jmxDomain", (Object)"org.infinispan").immutable().build();
    public static final AttributeDefinition<MBeanServerLookup> MBEAN_SERVER_LOOKUP = AttributeDefinition.builder((String)"mBeanServerLookup", (Object)((MBeanServerLookup)Util.getInstance(PlatformMBeanServerLookup.class))).immutable().build();
    public static final AttributeDefinition<Boolean> ALLOW_DUPLICATE_DOMAINS = AttributeDefinition.builder((String)"allowDuplicateDomains", (Object)false).immutable().build();
    public static final AttributeDefinition<String> CACHE_MANAGER_NAME = AttributeDefinition.builder((String)"cacheManagerName", (Object)"DefaultCacheManager").immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder((String)"properties", null, TypedProperties.class).immutable().initializer((AttributeInitializer)new AttributeInitializer<TypedProperties>(){

        public TypedProperties initialize() {
            return new TypedProperties();
        }
    }).build();
    private final Attribute<Boolean> enabled;
    private final Attribute<String> jmxDomain;
    private final Attribute<MBeanServerLookup> mBeanServerLookup;
    private final Attribute<Boolean> allowDuplicateDomains;
    private final Attribute<String> cacheManagerName;
    private final Attribute<TypedProperties> properties;
    private final AttributeSet attributes;

    public static final AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalJmxStatisticsConfiguration.class, new AttributeDefinition[]{ENABLED, JMX_DOMAIN, MBEAN_SERVER_LOOKUP, ALLOW_DUPLICATE_DOMAINS, CACHE_MANAGER_NAME, PROPERTIES});
    }

    GlobalJmxStatisticsConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.jmxDomain = attributes.attribute(JMX_DOMAIN);
        this.mBeanServerLookup = attributes.attribute(MBEAN_SERVER_LOOKUP);
        this.allowDuplicateDomains = attributes.attribute(ALLOW_DUPLICATE_DOMAINS);
        this.cacheManagerName = attributes.attribute(CACHE_MANAGER_NAME);
        this.properties = attributes.attribute(PROPERTIES);
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public String domain() {
        return (String)this.jmxDomain.get();
    }

    public TypedProperties properties() {
        return (TypedProperties)this.properties.get();
    }

    public boolean allowDuplicateDomains() {
        return (Boolean)this.allowDuplicateDomains.get();
    }

    public String cacheManagerName() {
        return (String)this.cacheManagerName.get();
    }

    public MBeanServerLookup mbeanServerLookup() {
        return (MBeanServerLookup)this.mBeanServerLookup.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalJmxStatisticsConfiguration other = (GlobalJmxStatisticsConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public String toString() {
        return "GlobalJmxStatisticsConfiguration [attributes=" + this.attributes + "]";
    }
}

