/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.registry.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.filter.KeyFilter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.registry.ScopedKey;
import org.infinispan.registry.impl.SecurityActions;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ClusterRegistryImpl<S, K, V>
implements ClusterRegistry<S, K, V> {
    public static final String GLOBAL_REGISTRY_CACHE_NAME = "__cluster_registry_cache__";
    private static final Log log = LogFactory.getLog(ClusterRegistryImpl.class);
    private EmbeddedCacheManager cacheManager;
    private volatile Cache<ScopedKey<S, K>, V> clusterRegistryCache;
    private volatile AdvancedCache<ScopedKey<S, K>, V> clusterRegistryCacheWithoutReturn;
    private volatile TransactionManager transactionManager;

    @Inject
    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Stop(priority=1)
    public void stop() {
        if (this.clusterRegistryCache != null) {
            this.clusterRegistryCache.stop();
        }
        this.clusterRegistryCache = null;
    }

    protected void runCommand(Runnable runnable) {
        while (true) {
            try {
                runnable.run();
            }
            catch (CacheException e) {
                if (SuspectException.isSuspectExceptionInChain(e)) {
                    log.trace("Ignoring suspect exception and retrying operation for ClusterRegistry.");
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(final S scope, final K key, final V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed");
        }
        this.startRegistryCache();
        Transaction tx = this.suspendTx();
        try {
            this.runCommand(new Runnable(){

                @Override
                public void run() {
                    ClusterRegistryImpl.this.clusterRegistryCacheWithoutReturn.put(new ScopedKey<Object, Object>(scope, key), value);
                }
            });
        }
        finally {
            this.resumeTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(final S scope, final K key, final V value, final long lifespan, final TimeUnit unit) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed");
        }
        this.startRegistryCache();
        Transaction tx = this.suspendTx();
        try {
            this.runCommand(new Runnable(){

                @Override
                public void run() {
                    ClusterRegistryImpl.this.clusterRegistryCacheWithoutReturn.put(new ScopedKey<Object, Object>(scope, key), value, lifespan, unit);
                }
            });
        }
        finally {
            this.resumeTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(final S scope, final K key) {
        this.startRegistryCache();
        Transaction tx = this.suspendTx();
        try {
            this.runCommand(new Runnable(){

                @Override
                public void run() {
                    ClusterRegistryImpl.this.clusterRegistryCacheWithoutReturn.remove(new ScopedKey<Object, Object>(scope, key));
                }
            });
        }
        finally {
            this.resumeTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(S scope, K key) {
        this.startRegistryCache();
        Transaction tx = this.suspendTx();
        try {
            Object object = this.clusterRegistryCache.get(new ScopedKey<S, K>(scope, key));
            return (V)object;
        }
        finally {
            this.resumeTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(S scope, K key) {
        this.startRegistryCache();
        Transaction tx = this.suspendTx();
        try {
            boolean bl = this.clusterRegistryCache.containsKey(new ScopedKey<S, K>(scope, key));
            return bl;
        }
        finally {
            this.resumeTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keys(S scope) {
        this.startRegistryCache();
        HashSet result = new HashSet();
        Transaction tx = this.suspendTx();
        try {
            for (ScopedKey key : this.clusterRegistryCache.keySet()) {
                if (!key.hasScope(scope)) continue;
                result.add(key.getKey());
            }
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            this.resumeTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(S scope) {
        this.startRegistryCache();
        Transaction tx = this.suspendTx();
        try {
            for (final ScopedKey key : this.clusterRegistryCache.keySet()) {
                if (!key.hasScope(scope)) continue;
                this.runCommand(new Runnable(){

                    @Override
                    public void run() {
                        ClusterRegistryImpl.this.clusterRegistryCacheWithoutReturn.remove(key);
                    }
                });
            }
        }
        finally {
            this.resumeTx(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        this.startRegistryCache();
        Transaction tx = this.suspendTx();
        try {
            this.runCommand(new Runnable(){

                @Override
                public void run() {
                    ClusterRegistryImpl.this.clusterRegistryCache.clear();
                }
            });
        }
        finally {
            this.resumeTx(tx);
        }
    }

    @Override
    public void addListener(final S scope, Object listener) {
        this.startRegistryCache();
        this.clusterRegistryCache.addListener(listener, new KeyFilter(){

            public boolean accept(Object key) {
                ScopedKey scopedKey = (ScopedKey)key;
                return scopedKey.hasScope(scope);
            }
        });
    }

    @Override
    public void addListener(final S scope, final KeyFilter keyFilter, Object listener) {
        this.startRegistryCache();
        this.clusterRegistryCache.addListener(listener, new KeyFilter(){

            public boolean accept(Object key) {
                ScopedKey scopedKey = (ScopedKey)key;
                return scopedKey.hasScope(scope) && keyFilter.accept(scopedKey.getKey());
            }
        });
    }

    @Override
    public void removeListener(Object listener) {
        if (this.clusterRegistryCache != null) {
            this.clusterRegistryCache.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRegistryCache() {
        if (this.clusterRegistryCache == null) {
            ClusterRegistryImpl clusterRegistryImpl = this;
            synchronized (clusterRegistryImpl) {
                if (this.clusterRegistryCache != null) {
                    return;
                }
                SecurityActions.defineConfiguration(this.cacheManager, GLOBAL_REGISTRY_CACHE_NAME, this.getRegistryCacheConfig());
                this.clusterRegistryCache = SecurityActions.getRegistryCache(this.cacheManager);
                this.clusterRegistryCacheWithoutReturn = this.clusterRegistryCache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
                this.transactionManager = this.clusterRegistryCacheWithoutReturn.getTransactionManager();
            }
        }
    }

    private Configuration getRegistryCacheConfig() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        CacheMode cacheMode = this.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        configurationBuilder.clustering().cacheMode(cacheMode);
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup(null).invocationBatching().enable();
        configurationBuilder.clustering().stateTransfer().fetchInMemoryState(cacheMode.needsStateTransfer());
        configurationBuilder.security().authorization().disable();
        return configurationBuilder.build();
    }

    private boolean isClustered() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        return globalConfiguration.isClustered();
    }

    private Transaction suspendTx() {
        try {
            if (this.transactionManager == null) {
                return null;
            }
            return this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new CacheException("Unable to suspend ongoing transaction", (Throwable)e);
        }
    }

    private void resumeTx(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (InvalidTransactionException | SystemException e) {
            throw new CacheException("Unable to resume ongoing transaction", e);
        }
    }
}

