/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.util.concurrent.locks.containers.AbstractLockContainer;

@ThreadSafe
public abstract class AbstractStripedLockContainer<L extends Lock>
extends AbstractLockContainer<L> {
    private int lockSegmentMask;
    private int lockSegmentShift;
    private final Equivalence<Object> keyEquivalence;

    protected AbstractStripedLockContainer(Equivalence<Object> keyEquivalence) {
        this.keyEquivalence = keyEquivalence;
    }

    final int calculateNumberOfSegments(int concurrencyLevel) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrencyLevel; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        return numLocks;
    }

    final int hashToIndex(Object object) {
        return AbstractStripedLockContainer.hash(this.keyEquivalence.hashCode(object)) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    static int hash(int hashCode) {
        int h = hashCode;
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    @Override
    public L acquireLock(Object lockOwner, Object key, long timeout, TimeUnit unit) throws InterruptedException {
        boolean locked;
        Object lock = this.getLock(key);
        try {
            locked = this.tryLock(lock, timeout, unit, lockOwner);
        }
        catch (InterruptedException ie) {
            this.safeRelease(lock, lockOwner);
            throw ie;
        }
        catch (Throwable th) {
            this.safeRelease(lock, lockOwner);
            locked = false;
        }
        return (L)(locked ? lock : null);
    }

    @Override
    public void releaseLock(Object lockOwner, Object key) {
        Object lock = this.getLock(key);
        this.safeRelease(lock, lockOwner);
    }

    @Override
    public int getLockId(Object key) {
        return this.hashToIndex(key);
    }
}

