/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.advertise.impl;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.advertise.MulticastSocketFactory;

public class MulticastSocketFactoryImpl
implements MulticastSocketFactory {
    final Logger log = Logger.getLogger(this.getClass());
    private final boolean linuxlike;

    public MulticastSocketFactoryImpl() {
        String value = this.getSystemProperty("os.name");
        this.linuxlike = value != null && (value.toLowerCase().startsWith("linux") || value.toLowerCase().startsWith("mac") || value.toLowerCase().startsWith("hp"));
    }

    private String getSystemProperty(final String key) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(key);
                }
                catch (SecurityException e) {
                    MulticastSocketFactoryImpl.this.log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
        };
        return AccessController.doPrivileged(action);
    }

    @Override
    public MulticastSocket createMulticastSocket(InetAddress address, int port) throws IOException {
        if (address == null || !this.linuxlike) {
            return new MulticastSocket(port);
        }
        if (!address.isMulticastAddress()) {
            ModClusterLogger.LOGGER.createMulticastSocketWithUnicastAddress(address);
            return new MulticastSocket(port);
        }
        try {
            return new MulticastSocket(new InetSocketAddress(address, port));
        }
        catch (IOException e) {
            ModClusterLogger.LOGGER.potentialCrossTalking(e, address, address instanceof Inet4Address ? "IPv4" : "IPv6");
            return new MulticastSocket(port);
        }
    }
}

