/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilder;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManagerFactoryService;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistryService;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManagerFactory;

public class DistributableSingleSignOnManagerFactoryBuilder
implements org.wildfly.extension.undertow.security.sso.DistributableSingleSignOnManagerFactoryBuilder {
    private final SSOManagerFactoryBuilder builder;

    private static SSOManagerFactoryBuilder load() {
        Iterator<SSOManagerFactoryBuilder> i$ = ServiceLoader.load(SSOManagerFactoryBuilder.class, SSOManagerFactoryBuilder.class.getClassLoader()).iterator();
        if (i$.hasNext()) {
            SSOManagerFactoryBuilder builder = i$.next();
            return builder;
        }
        return null;
    }

    public DistributableSingleSignOnManagerFactoryBuilder() {
        this(DistributableSingleSignOnManagerFactoryBuilder.load());
    }

    private DistributableSingleSignOnManagerFactoryBuilder(SSOManagerFactoryBuilder builder) {
        this.builder = builder;
    }

    public ServiceBuilder<SingleSignOnManagerFactory> build(ServiceTarget target, ServiceName name, ServiceName hostServiceName) {
        ServiceName managerServiceName = name.append(new String[]{"distributable"});
        this.builder.build(target, managerServiceName, hostServiceName.getSimpleName()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        SessionManagerRegistryService.build(target, hostServiceName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return DistributableSingleSignOnManagerFactoryService.build(target, name, hostServiceName, managerServiceName);
    }
}

