/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VolatileStore
extends ObjectStore {
    private ConcurrentMap<Uid, byte[]> stateMap = new ConcurrentHashMap<Uid, byte[]>();

    public VolatileStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
    }

    @Override
    public boolean allObjUids(String s, InputObjectState buff, int m) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean allTypes(InputObjectState buff) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public int currentState(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("VolatileStore.currentState(Uid=" + u + ", typeName=" + tn + ")"));
        }
        return this.getState(u);
    }

    @Override
    public String getStoreName() {
        return "VolatileStore";
    }

    @Override
    public boolean commit_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public InputObjectState read_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("VolatileStore.read_committed(Uid=" + u + ", typeName=" + tn + ")"));
        }
        return this.read(u, tn, 1);
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean remove_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("VolatileStore.remove_committed(Uid=" + u + ", typeName=" + tn + ")"));
        }
        return this.remove(u, tn, 1);
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean write_committed(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("VolatileStore.write_committed(Uid=" + u + ", typeName=" + tn + ")"));
        }
        return this.write(u, tn, buff, 1);
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    protected boolean supressEntry(String name) {
        return false;
    }

    private boolean remove(Uid u, String tn, int state) throws ObjectStoreException {
        Object oldValue = this.stateMap.remove(u);
        return oldValue != null;
    }

    private InputObjectState read(Uid u, String tn, int state) throws ObjectStoreException {
        byte[] data = (byte[])this.stateMap.get(u);
        if (data != null) {
            InputObjectState new_image = new InputObjectState(u, tn, data);
            return new_image;
        }
        return null;
    }

    private boolean write(Uid u, String tn, OutputObjectState buff, int state) throws ObjectStoreException {
        this.stateMap.put(u, buff.buffer());
        return true;
    }

    private int getState(Uid u) {
        if (this.stateMap.containsKey(u)) {
            return 1;
        }
        return -1;
    }
}

