/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.HashMap;
import java.util.Map;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.CurrentTimeUtil;
import org.jacorb.notification.filter.ETCLEvaluator;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.ArrayOperator;
import org.jacorb.notification.filter.etcl.AssocOperator;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.IdentValue;
import org.jacorb.notification.filter.etcl.ImplicitOperator;
import org.jacorb.notification.filter.etcl.ImplicitOperatorNode;
import org.jacorb.notification.filter.etcl.NumberValue;
import org.jacorb.notification.filter.etcl.UnionPositionOperator;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.util.AbstractPoolable;
import org.omg.CORBA.Any;
import org.omg.TimeBase.UtcT;

public class EvaluationContext
extends AbstractPoolable {
    private Message message_;
    private final ETCLEvaluator etclEvaluator_;
    private final Map resultCache_;
    private final Map anyCache_;
    private final CurrentTimeUtil currentTimeUtil_;

    public EvaluationContext(ETCLEvaluator evaluator, CurrentTimeUtil currentTimeUtil) {
        this.etclEvaluator_ = evaluator;
        this.currentTimeUtil_ = currentTimeUtil;
        this.resultCache_ = new HashMap();
        this.anyCache_ = new HashMap();
    }

    public EvaluationContext(ETCLEvaluator evaluator) {
        this(evaluator, CurrentTimeUtil.LOCAL_TIME);
    }

    public void reset() {
        this.message_ = null;
        this.resultCache_.clear();
        this.anyCache_.clear();
    }

    public ETCLEvaluator getETCLEvaluator() {
        return this.etclEvaluator_;
    }

    public UtcT getCurrentTime() {
        return this.currentTimeUtil_.getCurrentTime();
    }

    public Message getCurrentMessage() {
        return this.message_;
    }

    public void setCurrentMessage(Message message) {
        this.message_ = message;
    }

    public void storeResult(String name, EvaluationResult value) {
        this.resultCache_.put(name, value);
    }

    public EvaluationResult lookupResult(String name) {
        return (EvaluationResult)this.resultCache_.get(name);
    }

    public void eraseResult(String name) {
        this.resultCache_.remove(name);
    }

    public void storeAny(String name, Any any) {
        this.anyCache_.put(name, any);
    }

    public Any lookupAny(String name) {
        return (Any)this.anyCache_.get(name);
    }

    public void eraseAny(String name) {
        this.anyCache_.remove(name);
    }

    public EvaluationResult extractFromMessage(EvaluationResult evaluationResult, ComponentName componentName, RuntimeVariable runtimeVariable) throws EvaluationException {
        ETCLComponentName _componentName = (ETCLComponentName)componentName;
        if (_componentName.right() != null) {
            return this.extractFromAny(_componentName.right(), evaluationResult.getAny(), runtimeVariable.toString());
        }
        return evaluationResult;
    }

    public EvaluationResult extractFromMessage(AbstractMessage message, ComponentName componentName) throws EvaluationException {
        ETCLComponentName _componentName = (ETCLComponentName)componentName;
        return this.extractFromAny(_componentName.left(), message.toAny(), _componentName.toString());
    }

    private EvaluationResult extractFromAny(AbstractTCLNode expr, Any any, String rootName) throws EvaluationException {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractFromAny\n\trootname=" + rootName + "\n\tvalue=" + any);
        }
        EvaluationResult _result = null;
        Any _any = null;
        Any _currentAny = any;
        StringBuffer _currentPath = new StringBuffer(rootName);
        for (AbstractTCLNode _currentOperator = expr; _currentOperator != null; _currentOperator = (AbstractTCLNode)_currentOperator.getNextSibling()) {
            _currentPath.append(_currentOperator.toString());
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("current path=" + _currentPath.toString());
                this.logger_.debug("current operator=" + _currentOperator.toString());
                this.logger_.debug("current any=" + _currentAny);
            }
            if ((_any = this.lookupAny(_currentPath.toString())) == null) {
                switch (_currentOperator.getType()) {
                    case 6: {
                        break;
                    }
                    case 32: {
                        this.logger_.debug("evaluate union by position");
                        UnionPositionOperator _upo = (UnionPositionOperator)_currentOperator;
                        if (_upo.isDefault()) {
                            _any = this.getETCLEvaluator().evaluateUnion(_currentAny);
                            break;
                        }
                        _any = this.getETCLEvaluator().evaluateUnion(_currentAny, _upo.getPosition());
                        break;
                    }
                    case 11: {
                        String _identifer = ((IdentValue)_currentOperator).getIdentifier();
                        _any = this.getETCLEvaluator().evaluateIdentifier(_currentAny, _identifer);
                        break;
                    }
                    case 21: {
                        int _pos = ((NumberValue)_currentOperator).getNumber().intValue();
                        _any = this.getETCLEvaluator().evaluateIdentifier(_currentAny, _pos);
                        break;
                    }
                    case 33: {
                        ImplicitOperator _op = ((ImplicitOperatorNode)_currentOperator).getOperator();
                        _any = _op.evaluateImplicit(this.getETCLEvaluator(), _currentAny);
                        _result = EvaluationResult.fromAny(_any);
                        _result.addAny(_currentAny);
                        return _result;
                    }
                    case 30: {
                        int _arrayIndex = ((ArrayOperator)_currentOperator).getArrayIndex();
                        _any = this.getETCLEvaluator().evaluateArrayIndex(_currentAny, _arrayIndex);
                        break;
                    }
                    case 31: {
                        String _assocName = ((AssocOperator)_currentOperator).getAssocName();
                        _any = this.getETCLEvaluator().evaluateNamedValueList(_currentAny, _assocName);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected operator: " + AbstractTCLNode.getNameForType(_currentOperator.getType()));
                    }
                }
            }
            if (_any == null) continue;
            this.storeAny(_currentPath.toString(), _any);
            _currentAny = _any;
        }
        _result = EvaluationResult.fromAny(_any);
        return _result;
    }
}

