/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.util;

public class ByteArrayKey {
    private int cacheH = 0;
    private byte[] bytes = null;
    private String cacheS = null;

    public ByteArrayKey(byte[] array) {
        this.bytes = array;
    }

    public ByteArrayKey(ByteArrayKey bak) {
        this.cacheH = bak.cacheH;
        this.cacheS = bak.cacheS;
        this.bytes = bak.bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        if (this.cacheH == 0) {
            long h = 1234L;
            if (this.bytes != null && this.bytes.length > 0) {
                int i = this.bytes.length;
                while (--i >= 0) {
                    h ^= (long)(this.bytes[i] * (i + 1));
                }
                this.cacheH = (int)(h >> 32 ^ h);
            }
        }
        return this.cacheH;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ByteArrayKey) {
            ByteArrayKey key = (ByteArrayKey)obj;
            if (this.bytes == key.bytes || this.bytes == null && key.bytes == null) {
                result = true;
            } else if (this.bytes != null && key.bytes != null && this.bytes.length == key.bytes.length) {
                result = true;
                for (int i = 0; i < this.bytes.length; ++i) {
                    if (this.bytes[i] == key.bytes[i]) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    public String toString() {
        if (this.cacheS == null) {
            this.cacheS = this.bytes == null ? "" : new String(this.bytes);
        }
        return this.cacheS;
    }
}

