/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.jboss.weld.interceptor.reader.ClassMetadataInterceptorFactory;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.reader.ReflectiveClassMetadata;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorFactory;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class DefaultMetadataCachingReader
implements MetadataCachingReader {
    private final LoadingCache<InterceptorFactory<?>, InterceptorMetadata<?>> interceptorMetadataCache;
    private final LoadingCache<ClassMetadata<?>, InterceptorMetadata<?>> classMetadataInterceptorMetadataCache;
    private final LoadingCache<Class<?>, ClassMetadata<?>> reflectiveClassMetadataCache;
    private final BeanManagerImpl manager;

    public DefaultMetadataCachingReader(BeanManagerImpl manager) {
        this.manager = manager;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.interceptorMetadataCache = cacheBuilder.build(new CacheLoader<InterceptorFactory<?>, InterceptorMetadata<?>>(){

            public InterceptorMetadata<?> load(InterceptorFactory<?> from) {
                return InterceptorMetadataUtils.readMetadataForInterceptorClass(from);
            }
        });
        this.classMetadataInterceptorMetadataCache = cacheBuilder.build(new CacheLoader<ClassMetadata<?>, InterceptorMetadata<?>>(){

            public InterceptorMetadata<?> load(ClassMetadata<?> from) {
                return InterceptorMetadataUtils.readMetadataForTargetClass(from);
            }
        });
        this.reflectiveClassMetadataCache = cacheBuilder.build(new CacheLoader<Class<?>, ClassMetadata<?>>(){

            public ClassMetadata<?> load(Class<?> from) {
                return ReflectiveClassMetadata.of(from);
            }
        });
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(InterceptorFactory<T> interceptorReference) {
        return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.interceptorMetadataCache, interceptorReference);
    }

    @Override
    public <T> TargetClassInterceptorMetadata<T> getTargetClassInterceptorMetadata(ClassMetadata<T> classMetadata) {
        return (TargetClassInterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.classMetadataInterceptorMetadataCache, classMetadata);
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(Class<T> clazz) {
        return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.interceptorMetadataCache, ClassMetadataInterceptorFactory.of(LoadingCacheUtils.getCacheValue(this.reflectiveClassMetadataCache, clazz), this.manager));
    }

    @Override
    public <T> ClassMetadata<T> getClassMetadata(Class<T> clazz) {
        return (ClassMetadata)LoadingCacheUtils.getCastCacheValue(this.reflectiveClassMetadataCache, clazz);
    }

    @Override
    public void cleanAfterBoot() {
        this.classMetadataInterceptorMetadataCache.invalidateAll();
    }
}

