/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import org.jboss.classfilewriter.code.CodeAttribute;

public class Boxing {
    private static final String JAVA_LANG_NUMBER = Number.class.getName();
    private static final String JAVA_LANG_CHARACTER = Character.class.getName();
    private static final String JAVA_LANG_BOOLEAN = Boolean.class.getName();
    private static final String VALUE_OF = "valueOf";

    private Boxing() {
    }

    public static void boxIfNecessary(CodeAttribute b, String desc) {
        if (desc.length() == 1) {
            char type = desc.charAt(0);
            switch (type) {
                case 'I': {
                    Boxing.boxInt(b);
                    break;
                }
                case 'J': {
                    Boxing.boxLong(b);
                    break;
                }
                case 'S': {
                    Boxing.boxShort(b);
                    break;
                }
                case 'F': {
                    Boxing.boxFloat(b);
                    break;
                }
                case 'D': {
                    Boxing.boxDouble(b);
                    break;
                }
                case 'B': {
                    Boxing.boxByte(b);
                    break;
                }
                case 'C': {
                    Boxing.boxChar(b);
                    break;
                }
                case 'Z': {
                    Boxing.boxBoolean(b);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot box unknown primitive type: " + type);
                }
            }
        }
    }

    public static CodeAttribute unbox(CodeAttribute b, String desc) {
        char type = desc.charAt(0);
        switch (type) {
            case 'I': {
                return Boxing.unboxInt(b);
            }
            case 'J': {
                return Boxing.unboxLong(b);
            }
            case 'S': {
                return Boxing.unboxShort(b);
            }
            case 'F': {
                return Boxing.unboxFloat(b);
            }
            case 'D': {
                return Boxing.unboxDouble(b);
            }
            case 'B': {
                return Boxing.unboxByte(b);
            }
            case 'C': {
                return Boxing.unboxChar(b);
            }
            case 'Z': {
                return Boxing.unboxBoolean(b);
            }
        }
        throw new RuntimeException("Cannot unbox unknown primitive type: " + type);
    }

    public static void boxInt(CodeAttribute bc) {
        bc.invokestatic("java.lang.Integer", VALUE_OF, "(I)Ljava/lang/Integer;");
    }

    public static void boxLong(CodeAttribute bc) {
        bc.invokestatic("java.lang.Long", VALUE_OF, "(J)Ljava/lang/Long;");
    }

    public static void boxShort(CodeAttribute bc) {
        bc.invokestatic("java.lang.Short", VALUE_OF, "(S)Ljava/lang/Short;");
    }

    public static void boxByte(CodeAttribute bc) {
        bc.invokestatic("java.lang.Byte", VALUE_OF, "(B)Ljava/lang/Byte;");
    }

    public static void boxFloat(CodeAttribute bc) {
        bc.invokestatic("java.lang.Float", VALUE_OF, "(F)Ljava/lang/Float;");
    }

    public static void boxDouble(CodeAttribute bc) {
        bc.invokestatic("java.lang.Double", VALUE_OF, "(D)Ljava/lang/Double;");
    }

    public static void boxChar(CodeAttribute bc) {
        bc.invokestatic(JAVA_LANG_CHARACTER, VALUE_OF, "(C)Ljava/lang/Character;");
    }

    public static void boxBoolean(CodeAttribute bc) {
        bc.invokestatic(JAVA_LANG_BOOLEAN, VALUE_OF, "(Z)Ljava/lang/Boolean;");
    }

    public static CodeAttribute unboxInt(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_NUMBER);
        bc.invokevirtual(JAVA_LANG_NUMBER, "intValue", "()I");
        return bc;
    }

    public static CodeAttribute unboxLong(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_NUMBER);
        bc.invokevirtual(JAVA_LANG_NUMBER, "longValue", "()J");
        return bc;
    }

    public static CodeAttribute unboxShort(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_NUMBER);
        bc.invokevirtual(JAVA_LANG_NUMBER, "shortValue", "()S");
        return bc;
    }

    public static CodeAttribute unboxByte(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_NUMBER);
        bc.invokevirtual(JAVA_LANG_NUMBER, "byteValue", "()B");
        return bc;
    }

    public static CodeAttribute unboxFloat(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_NUMBER);
        bc.invokevirtual(JAVA_LANG_NUMBER, "floatValue", "()F");
        return bc;
    }

    public static CodeAttribute unboxDouble(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_NUMBER);
        bc.invokevirtual(JAVA_LANG_NUMBER, "doubleValue", "()D");
        return bc;
    }

    public static CodeAttribute unboxChar(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_CHARACTER);
        bc.invokevirtual(JAVA_LANG_CHARACTER, "charValue", "()C");
        return bc;
    }

    public static CodeAttribute unboxBoolean(CodeAttribute bc) {
        bc.checkcast(JAVA_LANG_BOOLEAN);
        bc.invokevirtual(JAVA_LANG_BOOLEAN, "booleanValue", "()Z");
        return bc;
    }
}

