/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.metadata;

import java.util.List;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.metadata.PublishLocationAdapterImpl;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossPortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

abstract class AbstractMetaDataBuilderEJB {
    AbstractMetaDataBuilderEJB() {
    }

    final EJBArchiveMetaData create(Deployment dep) {
        WSLogger.ROOT_LOGGER.creatingEjbDeployment(dep.getSimpleName());
        EJBArchiveMetaData ejbArchiveMD = new EJBArchiveMetaData();
        this.buildEnterpriseBeansMetaData(dep, ejbArchiveMD);
        this.buildWebservicesMetaData(dep, ejbArchiveMD);
        return ejbArchiveMD;
    }

    protected abstract void buildEnterpriseBeansMetaData(Deployment var1, EJBArchiveMetaData var2);

    private void buildWebservicesMetaData(Deployment dep, EJBArchiveMetaData ejbArchiveMD) {
        JBossWebservicesMetaData webservicesMD = (JBossWebservicesMetaData)WSHelper.getOptionalAttachment((Deployment)dep, JBossWebservicesMetaData.class);
        if (webservicesMD == null) {
            return;
        }
        String contextRoot = webservicesMD.getContextRoot();
        ejbArchiveMD.setWebServiceContextRoot(contextRoot);
        WSLogger.ROOT_LOGGER.settingContextRoot(contextRoot);
        String configName = webservicesMD.getConfigName();
        ejbArchiveMD.setConfigName(configName);
        WSLogger.ROOT_LOGGER.settingConfigName(configName);
        String configFile = webservicesMD.getConfigFile();
        ejbArchiveMD.setConfigFile(configFile);
        WSLogger.ROOT_LOGGER.settingConfigFile(configFile);
        JBossWebserviceDescriptionMetaData[] wsDescriptionsMD = webservicesMD.getWebserviceDescriptions();
        PublishLocationAdapterImpl resolver = new PublishLocationAdapterImpl(wsDescriptionsMD);
        ejbArchiveMD.setPublishLocationAdapter((PublishLocationAdapter)resolver);
    }

    protected JBossPortComponentMetaData getPortComponent(String ejbName, JBossWebservicesMetaData jbossWebservicesMD) {
        if (jbossWebservicesMD == null) {
            return null;
        }
        for (JBossPortComponentMetaData jbossPortComponentMD : jbossWebservicesMD.getPortComponents()) {
            if (!ejbName.equals(jbossPortComponentMD.getEjbName())) continue;
            return jbossPortComponentMD;
        }
        return null;
    }

    protected void buildEnterpriseBeanMetaData(List<EJBMetaData> wsEjbsMD, EJBEndpoint ejbEndpoint, JBossWebservicesMetaData jbossWebservicesMD) {
        SLSBMetaData wsEjbMD = new SLSBMetaData();
        wsEjbMD.setEjbName(ejbEndpoint.getName());
        wsEjbMD.setEjbClass(ejbEndpoint.getClassName());
        JBossPortComponentMetaData portComponentMD = this.getPortComponent(ejbEndpoint.getName(), jbossWebservicesMD);
        if (portComponentMD != null) {
            wsEjbMD.setPortComponentName(portComponentMD.getPortComponentName());
            wsEjbMD.setPortComponentURI(portComponentMD.getPortComponentURI());
        }
        AbstractMetaDataBuilderEJB.buildSecurityMetaData((EJBMetaData)wsEjbMD, ejbEndpoint, portComponentMD);
        wsEjbsMD.add((EJBMetaData)wsEjbMD);
    }

    private static void buildSecurityMetaData(EJBMetaData wsEjbMD, EJBEndpoint ejbEndpoint, JBossPortComponentMetaData portComponentMD) {
        EJBSecurityMetaData smd = new EJBSecurityMetaData();
        String authMethod = AbstractMetaDataBuilderEJB.getAuthMethod(ejbEndpoint, portComponentMD);
        smd.setAuthMethod(authMethod);
        String transportGuarantee = AbstractMetaDataBuilderEJB.getTransportGuarantee(ejbEndpoint, portComponentMD);
        smd.setTransportGuarantee(transportGuarantee);
        boolean secureWsdlAccess = AbstractMetaDataBuilderEJB.isSecureWsdlAccess(ejbEndpoint, portComponentMD);
        smd.setSecureWSDLAccess(Boolean.valueOf(secureWsdlAccess));
        wsEjbMD.setSecurityMetaData(smd);
    }

    private static String getAuthMethod(EJBEndpoint ejbEndpoint, JBossPortComponentMetaData portComponentMD) {
        if (ejbEndpoint.getAuthMethod() != null) {
            return ejbEndpoint.getAuthMethod();
        }
        return portComponentMD != null ? portComponentMD.getAuthMethod() : null;
    }

    private static String getTransportGuarantee(EJBEndpoint ejbEndpoint, JBossPortComponentMetaData portComponentMD) {
        if (ejbEndpoint.getTransportGuarantee() != null) {
            return ejbEndpoint.getTransportGuarantee();
        }
        return portComponentMD != null ? portComponentMD.getTransportGuarantee() : null;
    }

    private static boolean isSecureWsdlAccess(EJBEndpoint ejbEndpoint, JBossPortComponentMetaData portComponentMD) {
        if (ejbEndpoint.isSecureWsdlAccess()) {
            return true;
        }
        return portComponentMD != null && portComponentMD.getSecureWSDLAccess() != null ? portComponentMD.getSecureWSDLAccess() : false;
    }
}

