/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.Arrays;
import java.util.Collection;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceProvider;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.group.ChannelGroupConfiguration;
import org.wildfly.clustering.server.group.ChannelGroupService;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.server.group.ChannelNodeFactoryProvider;

public class ChannelGroupProvider
implements ChannelServiceProvider {
    private static final Logger logger = Logger.getLogger(ChannelServiceProvider.class);

    public static ServiceName getServiceName(String cluster) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "group", cluster});
    }

    private static ContextNames.BindInfo createBinding(String cluster) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "group", cluster}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String cluster) {
        return Arrays.asList(ChannelGroupProvider.getServiceName(cluster), ChannelGroupProvider.createBinding(cluster).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String cluster, ModuleIdentifier moduleId) {
        ServiceName name = ChannelGroupProvider.getServiceName(cluster);
        ContextNames.BindInfo bindInfo = ChannelGroupProvider.createBinding(cluster);
        logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        ChannelGroupConfig config = new ChannelGroupConfig();
        ChannelGroupService service = new ChannelGroupService(config);
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, (Service)service).addDependency(GlobalComponentRegistryService.getServiceName((String)cluster)).addDependency(EmbeddedCacheManagerService.getServiceName((String)cluster), EmbeddedCacheManager.class, config.getCacheManagerInjector()).addDependency(ChannelNodeFactoryProvider.getServiceName(cluster), ChannelNodeFactory.class, config.getNodeFactoryInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindInfo.getBindName()})}).addDependency(name, Group.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        return Arrays.asList(builder.install(), binderBuilder.install());
    }

    static class ChannelGroupConfig
    implements ChannelGroupConfiguration {
        private final InjectedValue<EmbeddedCacheManager> manager = new InjectedValue();
        private final InjectedValue<ChannelNodeFactory> factory = new InjectedValue();

        ChannelGroupConfig() {
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.manager.getValue();
        }

        @Override
        public ChannelNodeFactory getNodeFactory() {
            return (ChannelNodeFactory)this.factory.getValue();
        }

        Injector<EmbeddedCacheManager> getCacheManagerInjector() {
            return this.manager;
        }

        Injector<ChannelNodeFactory> getNodeFactoryInjector() {
            return this.factory;
        }
    }
}

