/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.util.Iterator;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Server;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.UndertowEngine;

public class UndertowServer
implements Server {
    final UndertowService service;
    final Connector connector;

    public UndertowServer(UndertowService service, Connector connector) {
        this.service = service;
        this.connector = connector;
    }

    public Iterable<Engine> getEngines() {
        final Iterator servers = this.service.getServers().iterator();
        final Iterator<Engine> iterator = new Iterator<Engine>(){

            @Override
            public boolean hasNext() {
                return servers.hasNext();
            }

            @Override
            public Engine next() {
                org.wildfly.extension.undertow.Server server = (org.wildfly.extension.undertow.Server)servers.next();
                return new UndertowEngine(server, UndertowServer.this.service, UndertowServer.this.connector);
            }

            @Override
            public void remove() {
                servers.remove();
            }
        };
        return new Iterable<Engine>(){

            @Override
            public Iterator<Engine> iterator() {
                return iterator;
            }
        };
    }

    public String toString() {
        return UndertowService.UNDERTOW.getCanonicalName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowServer)) {
            return false;
        }
        UndertowServer server = (UndertowServer)object;
        return this.service.equals(server.service);
    }

    public int hashCode() {
        return this.service.hashCode();
    }
}

