/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;

public class PersistenceProviderDeploymentHolder {
    private final List<PersistenceProvider> providerList = Collections.synchronizedList(new ArrayList());
    private final List<PersistenceProviderAdaptor> adapterList = Collections.synchronizedList(new ArrayList());

    public PersistenceProviderDeploymentHolder(List<PersistenceProvider> providerList, List<PersistenceProviderAdaptor> adapterList) {
        this.providerList.addAll(providerList);
        if (adapterList != null) {
            this.adapterList.addAll(adapterList);
        }
    }

    public List<PersistenceProviderAdaptor> getAdapters() {
        return this.adapterList;
    }

    public List<PersistenceProvider> getProviders() {
        return this.providerList;
    }

    public static PersistenceProviderDeploymentHolder getPersistenceProviderDeploymentHolder(DeploymentUnit deploymentUnit) {
        deploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit);
        return (PersistenceProviderDeploymentHolder)deploymentUnit.getAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER);
    }

    public static void savePersistenceProviderInDeploymentUnit(DeploymentUnit deploymentUnit, List<PersistenceProvider> providerList, List<PersistenceProviderAdaptor> adaptorList) {
        PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = PersistenceProviderDeploymentHolder.getPersistenceProviderDeploymentHolder(deploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit));
        if (persistenceProviderDeploymentHolder == null) {
            persistenceProviderDeploymentHolder = new PersistenceProviderDeploymentHolder(providerList, adaptorList);
            deploymentUnit.putAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER, (Object)persistenceProviderDeploymentHolder);
        } else {
            persistenceProviderDeploymentHolder.providerList.addAll(providerList);
            if (adaptorList != null) {
                persistenceProviderDeploymentHolder.adapterList.addAll(adaptorList);
            }
        }
    }
}

