/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.SFSBInjectedXPCs;

public class SFSBCallStack {
    private static ThreadLocal<ArrayList<Map<String, ExtendedEntityManager>>> SFSBInvocationStack = new ThreadLocal<ArrayList<Map<String, ExtendedEntityManager>>>(){

        @Override
        protected ArrayList<Map<String, ExtendedEntityManager>> initialValue() {
            return new ArrayList<Map<String, ExtendedEntityManager>>();
        }
    };
    private static ThreadLocal<Map<String, ExtendedEntityManager>> sfsbCreationTimeXPCRegistration = new ThreadLocal();
    private static ThreadLocal<SFSBInjectedXPCs> sfsbCreationTimeInjectedXPCs = new ThreadLocal();
    private static ThreadLocal<Integer> sfsbCreationBeanNestingLevel = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public static int getSFSBCreationBeanNestingLevel() {
        return sfsbCreationBeanNestingLevel.get();
    }

    public static void beginSfsbCreation() {
        int no = sfsbCreationBeanNestingLevel.get();
        if (no == 0) {
            sfsbCreationTimeXPCRegistration.set(new HashMap());
            sfsbCreationTimeInjectedXPCs.set(new SFSBInjectedXPCs(sfsbCreationTimeInjectedXPCs.get(), null));
        } else {
            SFSBInjectedXPCs parent = sfsbCreationTimeInjectedXPCs.get();
            sfsbCreationTimeInjectedXPCs.set(new SFSBInjectedXPCs(parent, parent.getTopLevel()));
        }
        sfsbCreationBeanNestingLevel.set(no + 1);
    }

    public static void endSfsbCreation() {
        int no = sfsbCreationBeanNestingLevel.get();
        sfsbCreationBeanNestingLevel.set(--no);
        if (no == 0) {
            sfsbCreationTimeXPCRegistration.remove();
            sfsbCreationTimeInjectedXPCs.remove();
        } else {
            sfsbCreationTimeInjectedXPCs.set(sfsbCreationTimeInjectedXPCs.get().getParent());
        }
    }

    static SFSBInjectedXPCs getSFSBCreationTimeInjectedXPCs() {
        return sfsbCreationTimeInjectedXPCs.get();
    }

    public static ArrayList<Map<String, ExtendedEntityManager>> currentSFSBCallStack() {
        return SFSBInvocationStack.get();
    }

    public static Map<String, ExtendedEntityManager> currentSFSBCallStackInvocation() {
        ArrayList<Map<String, ExtendedEntityManager>> stack = SFSBInvocationStack.get();
        if (stack != null && stack.size() > 0) {
            return stack.get(stack.size() - 1);
        }
        return null;
    }

    public static void pushCall(Map<String, ExtendedEntityManager> entityManagers) {
        SFSBCallStack.currentSFSBCallStack().add(entityManagers);
        if (entityManagers != null) {
            for (ExtendedEntityManager extendedEntityManager : entityManagers.values()) {
                extendedEntityManager.internalAssociateWithJtaTx();
            }
        }
    }

    public static Map<String, ExtendedEntityManager> popCall() {
        ArrayList<Map<String, ExtendedEntityManager>> stack = SFSBCallStack.currentSFSBCallStack();
        Map<String, ExtendedEntityManager> result = stack.remove(stack.size() - 1);
        stack.trimToSize();
        return result;
    }

    static Map<String, ExtendedEntityManager> getCurrentCall() {
        ArrayList<Map<String, ExtendedEntityManager>> stack = SFSBCallStack.currentSFSBCallStack();
        Map<String, ExtendedEntityManager> result = null;
        if (stack != null) {
            result = stack.get(stack.size() - 1);
        }
        return result;
    }
}

