/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.util.Arrays;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.StreamMessage;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAMessage;
import org.hornetq.ra.HornetQRASession;

public class HornetQRAStreamMessage
extends HornetQRAMessage
implements StreamMessage {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();

    public HornetQRAStreamMessage(StreamMessage message, HornetQRASession session) {
        super((Message)message, session);
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + message + ", " + session + ")");
        }
    }

    public boolean readBoolean() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readBoolean()");
        }
        return ((StreamMessage)this.message).readBoolean();
    }

    public byte readByte() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readByte()");
        }
        return ((StreamMessage)this.message).readByte();
    }

    public int readBytes(byte[] value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readBytes(" + Arrays.toString(value) + ")");
        }
        return ((StreamMessage)this.message).readBytes(value);
    }

    public char readChar() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readChar()");
        }
        return ((StreamMessage)this.message).readChar();
    }

    public double readDouble() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readDouble()");
        }
        return ((StreamMessage)this.message).readDouble();
    }

    public float readFloat() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readFloat()");
        }
        return ((StreamMessage)this.message).readFloat();
    }

    public int readInt() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readInt()");
        }
        return ((StreamMessage)this.message).readInt();
    }

    public long readLong() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readLong()");
        }
        return ((StreamMessage)this.message).readLong();
    }

    public Object readObject() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readObject()");
        }
        return ((StreamMessage)this.message).readObject();
    }

    public short readShort() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readShort()");
        }
        return ((StreamMessage)this.message).readShort();
    }

    public String readString() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("readString()");
        }
        return ((StreamMessage)this.message).readString();
    }

    public void reset() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("reset()");
        }
        ((StreamMessage)this.message).reset();
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeBoolean(" + value + ")");
        }
        ((StreamMessage)this.message).writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeByte(" + value + ")");
        }
        ((StreamMessage)this.message).writeByte(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeBytes(" + value + ", " + offset + ", " + length + ")");
        }
        ((StreamMessage)this.message).writeBytes(value, offset, length);
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeBytes(" + value + ")");
        }
        ((StreamMessage)this.message).writeBytes(value);
    }

    public void writeChar(char value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeChar(" + value + ")");
        }
        ((StreamMessage)this.message).writeChar(value);
    }

    public void writeDouble(double value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeDouble(" + value + ")");
        }
        ((StreamMessage)this.message).writeDouble(value);
    }

    public void writeFloat(float value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeFloat(" + value + ")");
        }
        ((StreamMessage)this.message).writeFloat(value);
    }

    public void writeInt(int value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeInt(" + value + ")");
        }
        ((StreamMessage)this.message).writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeLong(" + value + ")");
        }
        ((StreamMessage)this.message).writeLong(value);
    }

    public void writeObject(Object value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeObject(" + value + ")");
        }
        ((StreamMessage)this.message).writeObject(value);
    }

    public void writeShort(short value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeShort(" + value + ")");
        }
        ((StreamMessage)this.message).writeShort(value);
    }

    public void writeString(String value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("writeString(" + value + ")");
        }
        ((StreamMessage)this.message).writeString(value);
    }
}

