/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.security.LegacySupport;
import org.jboss.as.security.LoginModuleResourceDefinition;
import org.jboss.as.security.SecurityDomainReloadAddHandler;
import org.jboss.as.security.SecurityDomainReloadRemoveHandler;
import org.jboss.as.security.SecurityExtension;
import org.jboss.dmr.ModelNode;

public class ACLResourceDefinition
extends SimpleResourceDefinition {
    public static final ACLResourceDefinition INSTANCE = new ACLResourceDefinition();
    public static final ListAttributeDefinition ACL_MODULES = new LegacySupport.LoginModulesAttributeDefinition("acl-modules", "acl-module");
    private static final OperationStepHandler LEGACY_ADD_HANDLER = new LegacySupport.LegacyModulesConverter("acl-module", ACL_MODULES);

    private ACLResourceDefinition() {
        super(SecurityExtension.ACL_PATH, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("acl"), (OperationStepHandler)ACLResourceDefinitionAdd.INSTANCE, (OperationStepHandler)new SecurityDomainReloadRemoveHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ACL_MODULES, (OperationStepHandler)new LegacySupport.LegacyModulesAttributeReader("acl-module"), (OperationStepHandler)new LegacySupport.LegacyModulesAttributeWriter("acl-module"));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        ManagementResourceRegistration moduleReg = resourceRegistration.registerSubModel((ResourceDefinition)new LoginModuleResourceDefinition("acl-module"));
        resourceRegistration.registerAlias(PathElement.pathElement((String)"login-module"), new AliasEntry(moduleReg){

            public PathAddress convertToTargetAddress(PathAddress address) {
                PathElement element = address.getLastElement();
                element = PathElement.pathElement((String)"acl-module", (String)element.getValue());
                return address.subAddress(0, address.size() - 1).append(new PathElement[]{element});
            }
        });
    }

    static class ACLResourceDefinitionAdd
    extends SecurityDomainReloadAddHandler {
        static final ACLResourceDefinitionAdd INSTANCE = new ACLResourceDefinitionAdd();

        ACLResourceDefinitionAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }

        protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.updateModel(context, operation);
            if (operation.hasDefined(ACL_MODULES.getName())) {
                context.addStep(new ModelNode(), operation, LEGACY_ADD_HANDLER, OperationContext.Stage.MODEL, true);
            }
        }
    }
}

