/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.security.ModuleFlag;
import org.jboss.as.security.SecurityDomainReloadRemoveHandler;
import org.jboss.as.security.SecurityMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

class LegacySupport {
    private LegacySupport() {
    }

    private static class LegacySupportListAttributeBuilder
    extends ListAttributeDefinition.Builder<LegacySupportListAttributeBuilder, ListAttributeDefinition> {
        private static LegacySupportListAttributeBuilder of(String attributeName, String xmlName, ParameterValidator elementValidator) {
            return (LegacySupportListAttributeBuilder)((LegacySupportListAttributeBuilder)((LegacySupportListAttributeBuilder)((LegacySupportListAttributeBuilder)((LegacySupportListAttributeBuilder)((LegacySupportListAttributeBuilder)((LegacySupportListAttributeBuilder)new LegacySupportListAttributeBuilder(attributeName).setXmlName(xmlName)).setElementValidator(elementValidator)).setAllowNull(true)).setMinSize(1)).setMaxSize(Integer.MAX_VALUE)).setDeprecated(ModelVersion.create((int)1, (int)2))).setRestartAllServices();
        }

        private LegacySupportListAttributeBuilder(String attributeName) {
            super(attributeName);
        }

        public ListAttributeDefinition build() {
            throw new UnsupportedOperationException();
        }
    }

    static class LegacyModulesConverter
    implements OperationStepHandler {
        private String newKeyName;
        private ListAttributeDefinition oldAttribute;

        LegacyModulesConverter(String newKeyName, ListAttributeDefinition oldAttribute) {
            this.newKeyName = newKeyName;
            this.oldAttribute = oldAttribute;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource existing = context.readResource(PathAddress.EMPTY_ADDRESS);
            OperationStepHandler addHandler = context.getResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS.append(this.newKeyName)).getOperationHandler(PathAddress.EMPTY_ADDRESS, "add");
            this.oldAttribute.validateOperation(operation);
            ArrayList modules = new ArrayList(operation.get(this.oldAttribute.getName()).asList());
            Collections.reverse(modules);
            for (ModelNode module : modules) {
                ModelNode addModuleOp = module.clone();
                String code = addModuleOp.get("code").asString();
                PathElement relativePath = PathElement.pathElement((String)this.newKeyName, (String)code);
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{relativePath});
                addModuleOp.get("address").set(address.toModelNode());
                addModuleOp.get("operation").set("add");
                context.addStep(new ModelNode(), addModuleOp, addHandler, OperationContext.Stage.MODEL, true);
            }
            for (Resource.ResourceEntry entry : existing.getChildren(this.newKeyName)) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{entry.getPathElement()});
                ModelNode removeModuleOp = Util.createRemoveOperation((PathAddress)address);
                context.addStep(new ModelNode(), removeModuleOp, (OperationStepHandler)new SecurityDomainReloadRemoveHandler(), OperationContext.Stage.MODEL, true);
            }
            context.stepCompleted();
        }
    }

    static class LegacyModulesAttributeWriter
    implements OperationStepHandler {
        private String newKeyName;

        LegacyModulesAttributeWriter(String newKeyName) {
            this.newKeyName = newKeyName;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource existing = context.readResource(PathAddress.EMPTY_ADDRESS);
            OperationStepHandler addHandler = context.getResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS.append(this.newKeyName)).getOperationHandler(PathAddress.EMPTY_ADDRESS, "add");
            ModelNode value = operation.get("value");
            if (value.isDefined()) {
                ArrayList modules = new ArrayList(value.asList());
                Collections.reverse(modules);
                for (ModelNode module : modules) {
                    ModelNode addModuleOp = module.clone();
                    String code = addModuleOp.get("code").asString();
                    PathElement relativePath = PathElement.pathElement((String)this.newKeyName, (String)code);
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{relativePath});
                    addModuleOp.get("address").set(address.toModelNode());
                    addModuleOp.get("operation").set("add");
                    context.addStep(new ModelNode(), addModuleOp, addHandler, OperationContext.Stage.MODEL, true);
                }
            }
            for (Resource.ResourceEntry entry : existing.getChildren(this.newKeyName)) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{entry.getPathElement()});
                ModelNode removeModuleOp = Util.createRemoveOperation((PathAddress)address);
                context.addStep(new ModelNode(), removeModuleOp, (OperationStepHandler)new SecurityDomainReloadRemoveHandler(), OperationContext.Stage.MODEL, true);
            }
            context.stepCompleted();
        }
    }

    static class LegacyModulesAttributeReader
    implements OperationStepHandler {
        private String newKeyName;

        LegacyModulesAttributeReader(String newKeyName) {
            this.newKeyName = newKeyName;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode authModules = Resource.Tools.readModel((Resource)resource).get(this.newKeyName);
            ModelNode result = new ModelNode();
            if (authModules.isDefined()) {
                List loginModules = authModules.asPropertyList();
                for (Property p : loginModules) {
                    result.add(p.getValue());
                }
            }
            context.getResult().set(result);
            context.stepCompleted();
        }
    }

    public static class ProviderModulesAttributeDefinition
    extends ListAttributeDefinition {
        public static final ParameterValidator validator;

        public ProviderModulesAttributeDefinition(String name, String xmlName) {
            super((ListAttributeDefinition.Builder)LegacySupportListAttributeBuilder.of(name, xmlName, ProviderModulesAttributeDefinition.validator));
        }

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            throw SecurityMessages.MESSAGES.unsupportedOperationExceptionUseResourceDesc();
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"module-options"}));
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"module-options"}));
        }

        public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
            throw SecurityMessages.MESSAGES.unsupportedOperation();
        }

        private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
            ModelNode valueType = parent.get("value-type");
            ModelNode code = valueType.get("code");
            code.get("description");
            code.get("type").set(ModelType.STRING);
            code.get("nillable").set(false);
            code.get("min-length").set(1);
            ModelNode moduleOptions = valueType.get("module-options");
            moduleOptions.get("description");
            moduleOptions.get("type").set(ModelType.OBJECT);
            moduleOptions.get("value-type").set(ModelType.STRING);
            moduleOptions.get("nillable").set(true);
            return valueType;
        }

        static {
            ParametersValidator delegate = new ParametersValidator();
            delegate.registerValidator("code", (ParameterValidator)new StringLengthValidator(1));
            delegate.registerValidator("module-options", (ParameterValidator)new ModelTypeValidator(ModelType.OBJECT, true));
            validator = new ParametersOfValidator(delegate);
        }
    }

    public static class MappingModulesAttributeDefinition
    extends ListAttributeDefinition {
        private static final ParameterValidator validator;

        public MappingModulesAttributeDefinition() {
            super((ListAttributeDefinition.Builder)LegacySupportListAttributeBuilder.of("mapping-modules", "mapping-module", MappingModulesAttributeDefinition.validator));
        }

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            throw SecurityMessages.MESSAGES.unsupportedOperationExceptionUseResourceDesc();
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"type", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"type"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"module-options"}));
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"type", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"type"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"module-options"}));
        }

        public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
            throw SecurityMessages.MESSAGES.unsupportedOperation();
        }

        private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
            ModelNode valueType = parent.get("value-type");
            ModelNode code = valueType.get("code");
            code.get("description");
            code.get("type").set(ModelType.STRING);
            code.get("nillable").set(false);
            code.get("min-length").set(1);
            ModelNode flag = valueType.get("type");
            flag.get("description");
            flag.get("type").set(ModelType.STRING);
            flag.get("nillable").set(false);
            ModelNode moduleOptions = valueType.get("module-options");
            moduleOptions.get("description");
            moduleOptions.get("type").set(ModelType.OBJECT);
            moduleOptions.get("value-type").set(ModelType.STRING);
            moduleOptions.get("nillable").set(true);
            return valueType;
        }

        static {
            ParametersValidator delegate = new ParametersValidator();
            delegate.registerValidator("code", (ParameterValidator)new StringLengthValidator(1));
            delegate.registerValidator("type", (ParameterValidator)new StringLengthValidator(1));
            delegate.registerValidator("module", (ParameterValidator)new StringLengthValidator(1, true));
            delegate.registerValidator("module-options", (ParameterValidator)new ModelTypeValidator(ModelType.OBJECT, true));
            validator = new ParametersOfValidator(delegate);
        }
    }

    public static class LoginModulesAttributeDefinition
    extends ListAttributeDefinition {
        public static final ParameterValidator validator;

        public LoginModulesAttributeDefinition(String name, String xmlName) {
            super((ListAttributeDefinition.Builder)LegacySupportListAttributeBuilder.of(name, xmlName, LoginModulesAttributeDefinition.validator));
        }

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            throw SecurityMessages.MESSAGES.unsupportedOperationExceptionUseResourceDesc();
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"flag", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"flag"}));
            valueType.get(new String[]{"module", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"module"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"module-options"}));
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"flag", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"flag"}));
            valueType.get(new String[]{"module", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"module"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"module-options"}));
        }

        public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
            throw SecurityMessages.MESSAGES.unsupportedOperation();
        }

        private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
            ModelNode valueType = parent.get("value-type");
            ModelNode code = valueType.get("code");
            code.get("description");
            code.get("type").set(ModelType.STRING);
            code.get("nillable").set(false);
            code.get("min-length").set(1);
            ModelNode flag = valueType.get("flag");
            flag.get("description");
            flag.get("type").set(ModelType.STRING);
            flag.get("nillable").set(false);
            for (ModuleFlag value : ModuleFlag.values()) {
                flag.get("allowed").add(value.toString());
            }
            ModelNode module = valueType.get("module");
            module.get("type").set(ModelType.STRING);
            module.get("nillable").set(true);
            ModelNode moduleOptions = valueType.get("module-options");
            moduleOptions.get("description");
            moduleOptions.get("type").set(ModelType.OBJECT);
            moduleOptions.get("value-type").set(ModelType.STRING);
            moduleOptions.get("nillable").set(true);
            return valueType;
        }

        static {
            ParametersValidator delegate = new ParametersValidator();
            delegate.registerValidator("code", (ParameterValidator)new StringLengthValidator(1));
            delegate.registerValidator("flag", (ParameterValidator)new EnumValidator(ModuleFlag.class, false, false));
            delegate.registerValidator("module", (ParameterValidator)new StringLengthValidator(1, true));
            delegate.registerValidator("module-options", (ParameterValidator)new ModelTypeValidator(ModelType.OBJECT, true));
            validator = new ParametersOfValidator(delegate);
        }
    }

    public static class JASPIAuthenticationModulesAttributeDefinition
    extends ListAttributeDefinition {
        private static final ParameterValidator validator;

        public JASPIAuthenticationModulesAttributeDefinition() {
            super((ListAttributeDefinition.Builder)LegacySupportListAttributeBuilder.of("auth-modules", "auth-module", JASPIAuthenticationModulesAttributeDefinition.validator));
        }

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            throw SecurityMessages.MESSAGES.unsupportedOperationExceptionUseResourceDesc();
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"flag", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"flag"}));
            valueType.get(new String[]{"module", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"module"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"module-options"}));
            valueType.get(new String[]{"login-module-stack-ref", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"login-module-stack-ref"}));
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(node);
            valueType.get(new String[]{"code", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"code"}));
            valueType.get(new String[]{"flag", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"flag"}));
            valueType.get(new String[]{"module", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"module"}));
            valueType.get(new String[]{"module-options", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"module-options"}));
            valueType.get(new String[]{"login-module-stack-ref", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"login-module-stack-ref"}));
        }

        public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
            throw SecurityMessages.MESSAGES.unsupportedOperation();
        }

        private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
            ModelNode valueType = parent.get("value-type");
            ModelNode code = valueType.get("code");
            code.get("description");
            code.get("type").set(ModelType.STRING);
            code.get("nillable").set(false);
            code.get("min-length").set(1);
            ModelNode flag = valueType.get("flag");
            flag.get("description");
            flag.get("type").set(ModelType.STRING);
            flag.get("nillable").set(true);
            for (ModuleFlag value : ModuleFlag.values()) {
                flag.get("allowed").add(value.toString());
            }
            ModelNode module = valueType.get("module");
            module.get("type").set(ModelType.STRING);
            module.get("nillable").set(true);
            ModelNode moduleOptions = valueType.get("module-options");
            moduleOptions.get("description");
            moduleOptions.get("type").set(ModelType.OBJECT);
            moduleOptions.get("value-type").set(ModelType.STRING);
            moduleOptions.get("nillable").set(true);
            ModelNode ref = valueType.get("login-module-stack-ref");
            ref.get("description");
            ref.get("type").set(ModelType.STRING);
            ref.get("nillable").set(true);
            ref.get("min-length").set(1);
            return valueType;
        }

        static {
            ParametersValidator delegate = new ParametersValidator();
            delegate.registerValidator("code", (ParameterValidator)new StringLengthValidator(1));
            delegate.registerValidator("flag", (ParameterValidator)new EnumValidator(ModuleFlag.class, true, false));
            delegate.registerValidator("module", (ParameterValidator)new StringLengthValidator(1, true));
            delegate.registerValidator("module-options", (ParameterValidator)new ModelTypeValidator(ModelType.OBJECT, true));
            delegate.registerValidator("login-module-stack-ref", (ParameterValidator)new StringLengthValidator(1, true));
            validator = new ParametersOfValidator(delegate);
        }
    }
}

