/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.config.AnnotationAttributeConfig;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;

public final class AnnotationConfig<DescriptorType extends AnnotatedDescriptor> {
    private final String name;
    private final Map<String, AnnotationAttributeConfig> attributes;
    private final AnnotationMetadataCreator<?, DescriptorType> annotationMetadataCreator;

    private AnnotationConfig(String name, Map<String, AnnotationAttributeConfig> attributes, AnnotationMetadataCreator<?, DescriptorType> annotationMetadataCreator) {
        this.name = name;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.annotationMetadataCreator = annotationMetadataCreator;
    }

    public String name() {
        return this.name;
    }

    public Map<String, AnnotationAttributeConfig> attributes() {
        return this.attributes;
    }

    public AnnotationMetadataCreator<?, DescriptorType> annotationMetadataCreator() {
        return this.annotationMetadataCreator;
    }

    public static final class Builder<DescriptorType extends AnnotatedDescriptor> {
        private final Configuration.Builder parentBuilder;
        private String name;
        private final Map<String, AnnotationAttributeConfig.Builder<DescriptorType>> attributeBuilders = new HashMap<String, AnnotationAttributeConfig.Builder<DescriptorType>>();
        private AnnotationMetadataCreator<?, DescriptorType> annotationMetadataCreator;

        Builder(Configuration.Builder parentBuilder, String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("annotation name must not be null or empty");
            }
            this.name = name;
            this.parentBuilder = parentBuilder;
        }

        public AnnotationAttributeConfig.Builder<DescriptorType> attribute(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("attribute name must not be null or empty");
            }
            AnnotationAttributeConfig.Builder annotationAttributeConfigBuilder = new AnnotationAttributeConfig.Builder(this, name);
            this.attributeBuilders.put(name, annotationAttributeConfigBuilder);
            return annotationAttributeConfigBuilder;
        }

        public Builder<DescriptorType> annotationMetadataCreator(AnnotationMetadataCreator<?, DescriptorType> annotationMetadataCreator) {
            this.annotationMetadataCreator = annotationMetadataCreator;
            return this;
        }

        public Builder<Descriptor> messageAnnotation(String annotationName) {
            return this.parentBuilder.messageAnnotation(annotationName);
        }

        public Builder<EnumDescriptor> enumAnnotation(String annotationName) {
            return this.parentBuilder.enumAnnotation(annotationName);
        }

        public Builder<FieldDescriptor> fieldAnnotation(String annotationName) {
            return this.parentBuilder.fieldAnnotation(annotationName);
        }

        AnnotationConfig<DescriptorType> buildAnnotationConfig() {
            HashMap<String, AnnotationAttributeConfig> attributes = new HashMap<String, AnnotationAttributeConfig>(this.attributeBuilders.size());
            for (AnnotationAttributeConfig.Builder<DescriptorType> attributeBuilder : this.attributeBuilders.values()) {
                AnnotationAttributeConfig annotationAttributeConfig = attributeBuilder.buildAnnotationAttributeConfig();
                attributes.put(annotationAttributeConfig.name(), annotationAttributeConfig);
            }
            return new AnnotationConfig(this.name, attributes, this.annotationMetadataCreator);
        }

        public Configuration build() {
            return this.parentBuilder.build();
        }
    }
}

