/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.concurrent.handle.ContextHandle;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.msc.service.ServiceName;

public class NamingContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "NAMING";
    private final NamespaceContextSelector namespaceContextSelector;
    private final ServiceName duServiceName;

    public NamingContextHandleFactory(NamespaceContextSelector namespaceContextSelector, ServiceName duServiceName) {
        this.namespaceContextSelector = namespaceContextSelector;
        this.duServiceName = duServiceName;
    }

    @Override
    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new NamingContextHandle(this.namespaceContextSelector, this.duServiceName);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 200;
    }

    @Override
    public void writeHandle(ContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    @Override
    public ContextHandle readHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new NamingContextHandle(this.namespaceContextSelector, this.duServiceName);
    }

    private static class NamingContextHandle
    implements ContextHandle {
        private final NamespaceContextSelector namespaceContextSelector;
        private final ServiceName duServiceName;

        private NamingContextHandle(NamespaceContextSelector namespaceContextSelector, ServiceName duServiceName) {
            this.namespaceContextSelector = namespaceContextSelector;
            this.duServiceName = duServiceName;
        }

        @Override
        public String getFactoryName() {
            return NamingContextHandleFactory.NAME;
        }

        @Override
        public void setup() throws IllegalStateException {
            if (this.namespaceContextSelector != null) {
                NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.namespaceContextSelector);
            }
            if (this.duServiceName != null) {
                WritableServiceBasedNamingStore.pushOwner((ServiceName)this.duServiceName);
            }
        }

        @Override
        public void reset() {
            if (this.namespaceContextSelector != null) {
                NamespaceContextSelector.popCurrentSelector();
            }
            if (this.duServiceName != null) {
                WritableServiceBasedNamingStore.popOwner();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }
    }
}

