/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class CdiConstructorInjector
implements ConstructorInjector {
    private BeanManager manager;
    private Type type;
    private static final Logger log = Logger.getLogger(CdiConstructorInjector.class);

    public CdiConstructorInjector(Type type, BeanManager manager) {
        this.type = type;
        this.manager = manager;
    }

    public Object construct() {
        HashSet beans = this.manager.getBeans(this.type, new Annotation[0]);
        if (beans.size() > 1) {
            HashSet modifiableBeans = new HashSet();
            modifiableBeans.addAll(beans);
            Iterator iterator = modifiableBeans.iterator();
            while (iterator.hasNext()) {
                Bean bean = (Bean)iterator.next();
                if (bean.getBeanClass().equals(this.type) || bean.isAlternative()) continue;
                iterator.remove();
            }
            beans = modifiableBeans;
        }
        log.debug("Beans found for {0} : {1}", new Object[]{this.type, beans});
        Bean bean = this.manager.resolve(beans);
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
        return this.manager.getReference(bean, this.type, context);
    }

    public Object construct(HttpRequest request, HttpResponse response) throws Failure, WebApplicationException, ApplicationException {
        return this.construct();
    }

    public Object[] injectableArguments() {
        return new Object[0];
    }

    public Object[] injectableArguments(HttpRequest request, HttpResponse response) throws Failure {
        return this.injectableArguments();
    }
}

