/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
implements Node {
    private ArchivePath path;
    private Asset asset;
    private Set<Node> children = Collections.synchronizedSet(new HashSet());

    public NodeImpl(ArchivePath path) {
        this(path, null);
    }

    public NodeImpl(ArchivePath path, Asset asset) {
        Validate.notNull(path, "Path was not specified");
        this.path = path;
        this.asset = asset;
    }

    public ArchivePath getPath() {
        return this.path;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public Set<Node> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    public void addChild(Node node) {
        Validate.notNull(node, "No node was specified");
        this.children.add(node);
    }

    public void removeChild(Node node) {
        Validate.notNull(node, "No node was specified");
        this.children.remove(node);
    }

    public boolean equals(Object obj) {
        Node node;
        return obj instanceof Node && this.path.equals((node = (Node)obj).getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path.get();
    }
}

