/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.PreModificationState;
import org.jboss.as.domain.management.security.adduser.PromptGroupsState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.ValidatePasswordState;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.RestrictionLevel;

public class PromptPasswordState
implements State {
    private final ConsoleWrapper theConsole;
    private final StateValues stateValues;
    private final boolean rePrompt;

    public PromptPasswordState(ConsoleWrapper theConsole, StateValues stateValues, boolean rePrompt) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        this.rePrompt = rePrompt;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        if (!this.stateValues.isSilentOrNonInteractive()) {
            if (!this.rePrompt) {
                List<PasswordRestriction> passwordRestrictions;
                RestrictionLevel level = this.stateValues.getOptions().getCheckUtil().getRestrictionLevel();
                if (!RestrictionLevel.RELAX.equals((Object)level) && (passwordRestrictions = this.stateValues.getOptions().getCheckUtil().getPasswordRestrictions()).size() > 0) {
                    if (level == RestrictionLevel.REJECT) {
                        this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordRequirements(), new Object[0]);
                    } else {
                        this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordRecommendations(), new Object[0]);
                    }
                    this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                    for (PasswordRestriction passwordRestriction : passwordRestrictions) {
                        String message = passwordRestriction.getRequirementMessage();
                        if (message == null || message.isEmpty()) continue;
                        this.theConsole.printf(" - ", new Object[0]);
                        this.theConsole.printf(message, new Object[0]);
                        this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                    }
                }
                this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordPrompt(), new Object[0]);
                char[] tempChar = this.theConsole.readPassword(" : ", new Object[0]);
                if (tempChar == null || tempChar.length == 0) {
                    return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.noPasswordExiting());
                }
                this.stateValues.setPassword(new String(tempChar));
                return new ValidatePasswordState(this.theConsole, this.stateValues);
            }
            this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordConfirmationPrompt(), new Object[0]);
            char[] secondTempChar = this.theConsole.readPassword(" : ", new Object[0]);
            if (secondTempChar == null) {
                secondTempChar = new char[]{};
            }
            if (!Arrays.equals(this.stateValues.getPassword().toCharArray(), secondTempChar)) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.passwordMisMatch(), new PromptPasswordState(this.theConsole, this.stateValues, false));
            }
            return this.stateValues.groupPropertiesFound() ? new PromptGroupsState(this.theConsole, this.stateValues) : new PreModificationState(this.theConsole, this.stateValues);
        }
        return new ValidatePasswordState(this.theConsole, this.stateValues);
    }
}

