/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceAwareObjectFactory;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;

public class ServiceReferenceObjectFactory
implements ServiceAwareObjectFactory {
    private volatile ServiceRegistry serviceRegistry;

    public static Reference createReference(ServiceName service, Class<? extends ServiceReferenceObjectFactory> factory) {
        return ModularReference.create(Context.class, (RefAddr)new ServiceNameRefAdr("srof", service), factory);
    }

    public void injectServiceRegistry(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    public final Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ServiceController controller;
        Reference reference = (Reference)obj;
        ServiceNameRefAdr nameAdr = (ServiceNameRefAdr)reference.get("srof");
        if (nameAdr == null) {
            throw NamingMessages.MESSAGES.invalidContextReference("srof");
        }
        ServiceName serviceName = (ServiceName)nameAdr.getContent();
        try {
            controller = this.serviceRegistry.getRequiredService(serviceName);
        }
        catch (ServiceNotFoundException e) {
            throw NamingMessages.MESSAGES.cannotResolveService(serviceName);
        }
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(controller);
        try {
            monitor.awaitStability();
        }
        catch (InterruptedException e) {
            throw NamingMessages.MESSAGES.threadInterrupt(serviceName);
        }
        finally {
            monitor.removeController(controller);
        }
        switch (controller.getState()) {
            case UP: {
                return this.getObjectInstance(controller.getValue(), obj, name, nameCtx, environment);
            }
            case START_FAILED: {
                throw NamingMessages.MESSAGES.cannotResolveService(serviceName, this.getClass().getName(), "START_FAILED");
            }
            case REMOVED: {
                throw NamingMessages.MESSAGES.cannotResolveService(serviceName, this.getClass().getName(), "REMOVED");
            }
        }
        throw NamingMessages.MESSAGES.cannotResolveServiceBug(serviceName, this.getClass().getName(), controller.getState().toString());
    }

    public Object getObjectInstance(Object serviceValue, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        return serviceValue;
    }

    private static final class ServiceNameRefAdr
    extends RefAddr {
        private static final long serialVersionUID = 3677121114687908679L;
        private final ServiceName serviceName;

        private ServiceNameRefAdr(String s, ServiceName serviceName) {
            super(s);
            this.serviceName = serviceName;
        }

        @Override
        public Object getContent() {
            return this.serviceName;
        }
    }
}

