/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectTypeAttributeDefinition
extends SimpleAttributeDefinition {
    private final AttributeDefinition[] valueTypes;
    private final String suffix;

    @Deprecated
    protected ObjectTypeAttributeDefinition(String name, AttributeDefinition[] valueTypes, boolean allowNull, ParameterCorrector corrector) {
        this(name, name, null, valueTypes, allowNull, (ParameterValidator)new ObjectTypeValidator(allowNull, valueTypes), corrector, null, null, null, false, null, null, (Boolean)null, null, (AttributeAccess.Flag[])null);
    }

    @Deprecated
    protected ObjectTypeAttributeDefinition(String name, String xmlName, String suffix, AttributeDefinition[] valueTypes, boolean allowNull, ParameterValidator validator, ParameterCorrector corrector, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AttributeAccess.Flag ... flags) {
        this(name, xmlName, suffix, valueTypes, allowNull, validator, corrector, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, (AccessConstraintDefinition[])null, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ObjectTypeAttributeDefinition(String name, String xmlName, String suffix, AttributeDefinition[] valueTypes, boolean allowNull, ParameterValidator validator, ParameterCorrector corrector, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        this(name, xmlName, suffix, valueTypes, allowNull, validator, corrector, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ObjectTypeAttributeDefinition(String name, String xmlName, String suffix, AttributeDefinition[] valueTypes, boolean allowNull, ParameterValidator validator, ParameterCorrector corrector, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean nullSignificant, AttributeParser parser, AttributeAccess.Flag ... flags) {
        super(name, xmlName, null, ModelType.OBJECT, allowNull, false, null, corrector, validator, false, alternatives, requires, ObjectTypeAttributeDefinition.getAttributeMarshaller(attributeMarshaller, valueTypes), resourceOnly, deprecated, accessConstraints, nullSignificant, parser, flags);
        this.valueTypes = valueTypes;
        this.suffix = suffix == null ? "" : suffix;
    }

    protected ObjectTypeAttributeDefinition(Builder builder) {
        this(builder, builder.suffix, builder.valueTypes);
    }

    protected ObjectTypeAttributeDefinition(AbstractAttributeDefinitionBuilder<?, ? extends ObjectTypeAttributeDefinition> builder, String suffix, AttributeDefinition[] valueTypes) {
        super((AbstractAttributeDefinitionBuilder<?, ? extends SimpleAttributeDefinition>)builder);
        this.valueTypes = valueTypes;
        this.suffix = suffix == null ? "" : suffix;
    }

    private static AttributeMarshaller getAttributeMarshaller(AttributeMarshaller provided, final AttributeDefinition[] valueTypes) {
        return provided != null ? provided : new AttributeMarshaller(){

            @Override
            public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                if (resourceModel.hasDefined(attribute.getName())) {
                    writer.writeStartElement(attribute.getXmlName());
                    for (AttributeDefinition valueType : valueTypes) {
                        for (ModelNode handler : resourceModel.get(attribute.getName()).asList()) {
                            valueType.marshallAsElement(handler, writer);
                        }
                    }
                    writer.writeEndElement();
                }
            }
        };
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        ModelNode result = parameter;
        if (parameter.isDefined()) {
            boolean changeMade = false;
            ModelNode updated = new ModelNode().setEmptyObject();
            for (AttributeDefinition ad : this.valueTypes) {
                String fieldName = ad.getName();
                if (!parameter.has(fieldName)) continue;
                ModelNode orig = parameter.get(fieldName);
                if (!orig.isDefined()) {
                    updated.get(fieldName);
                    continue;
                }
                ModelNode converted = ad.convertParameterExpressions(orig);
                changeMade |= !orig.equals(converted);
                updated.get(fieldName).set(converted);
            }
            if (changeMade) {
                result = updated;
            }
        }
        return result;
    }

    @Override
    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, prefix, bundle2, null, null);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addValueTypeDescription(result, this.getName(), bundle2, resolver, locale);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addValueTypeDescription(result, this.getName(), bundle2, resolver, locale);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, prefix, bundle2, null, null);
        return result;
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle2, ResourceDescriptionResolver resolver, Locale locale) {
        for (AttributeDefinition valueType : this.valueTypes) {
            boolean suffixUnusable;
            ModelNode valueTypeDesc = this.getValueTypeDescription(valueType, false);
            boolean prefixUnusable = prefix == null || prefix.isEmpty();
            boolean bl = suffixUnusable = this.suffix == null || this.suffix.isEmpty();
            String p = prefixUnusable && !suffixUnusable ? this.suffix : (!prefixUnusable && suffixUnusable ? prefix : String.format("%s.%s", prefix, this.suffix));
            if (resolver != null) {
                String key = String.format("%s.%s", p, valueType.getName());
                valueTypeDesc.get("description").set(resolver.getResourceAttributeDescription(key, locale, bundle2));
            } else {
                valueTypeDesc.get("description").set(valueType.getAttributeTextDescription(bundle2, p));
            }
            ModelNode childType = node.get(new String[]{"value-type", valueType.getName()}).set(valueTypeDesc);
            if (valueType instanceof ObjectTypeAttributeDefinition) {
                ((ObjectTypeAttributeDefinition)ObjectTypeAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle2, resolver, locale);
            }
            if (!(valueType instanceof SimpleListAttributeDefinition)) continue;
            ((SimpleListAttributeDefinition)SimpleListAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle2);
        }
    }

    private ModelNode getValueTypeDescription(AttributeDefinition valueType, boolean forOperation) {
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        ModelNode result = new ModelNode();
        result.get("type").set(valueType.getType());
        result.get("description");
        result.get("expressions-allowed").set(valueType.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!valueType.isAllowNull());
        }
        result.get("nillable").set(valueType.isAllowNull());
        ModelNode defaultValue = valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            result.get("default").set(defaultValue);
        }
        if ((measurementUnit = valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if ((requires = valueType.getRequires()) != null) {
            for (String required : requires) {
                result.get("requires").add(required);
            }
        }
        if ((validator = valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void addAllowedValuesToDescription(ModelNode result, ParameterValidator validator) {
    }

    public static final class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, ObjectTypeAttributeDefinition> {
        private String suffix;
        private final AttributeDefinition[] valueTypes;

        public Builder(String name, AttributeDefinition ... valueTypes) {
            super(name, ModelType.OBJECT, true);
            this.valueTypes = valueTypes;
        }

        public static Builder of(String name, AttributeDefinition ... valueTypes) {
            return new Builder(name, valueTypes);
        }

        public static Builder of(String name, AttributeDefinition[] valueTypes, AttributeDefinition[] moreValueTypes) {
            ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>(Arrays.asList(valueTypes));
            list.addAll(Arrays.asList(moreValueTypes));
            AttributeDefinition[] allValueTypes = new AttributeDefinition[list.size()];
            list.toArray(allValueTypes);
            return new Builder(name, allValueTypes);
        }

        @Override
        public ObjectTypeAttributeDefinition build() {
            if (this.validator == null) {
                this.validator = new ObjectTypeValidator(this.allowNull, this.valueTypes);
            }
            return new ObjectTypeAttributeDefinition(this);
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        public Builder setAllowNull(boolean allowNull) {
            return (Builder)super.setAllowNull(allowNull);
        }
    }
}

