/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

class TransformerExpressionResolver
implements ExpressionResolver {
    private final Map<String, String> properties;
    private final Map<String, String> environment;
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;

    static ExpressionResolver create(OperationContext context, TransformationTarget.TransformationTargetType type) {
        switch (type) {
            default: 
        }
        Map<String, String> environment = Collections.emptyMap();
        HashMap<String, String> properties = new HashMap<String, String>();
        PathElement systemProperty = PathElement.pathElement("system-property");
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(systemProperty);
        if (context.getRootResourceRegistration().getChildNames(address).contains("system-property")) {
            Resource resource = context.readResourceFromRoot(PathAddress.pathAddress(systemProperty));
            for (Resource.ResourceEntry entry : resource.getChildren("system-property")) {
                ModelNode model = entry.getModel();
                properties.put(entry.getPathElement().getValue(), model.get("value").asString());
            }
        }
        return new TransformerExpressionResolver(properties, environment);
    }

    TransformerExpressionResolver(Map<String, String> properties, Map<String, String> environment) {
        this.properties = properties;
        this.environment = environment;
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.resolveExpressionsRecursively(node);
    }

    private ModelNode resolveExpressionsRecursively(ModelNode node) {
        ModelNode resolved;
        if (!node.isDefined()) {
            return node;
        }
        if (node.getType() == ModelType.EXPRESSION) {
            resolved = node.clone();
            this.resolvePluggableExpression(resolved);
        } else if (node.getType() == ModelType.OBJECT) {
            resolved = node.clone();
            for (Property prop : resolved.asPropertyList()) {
                resolved.get(prop.getName()).set(this.resolveExpressionsRecursively(prop.getValue()));
            }
        } else if (node.getType() == ModelType.LIST) {
            resolved = node.clone();
            ModelNode list = new ModelNode();
            for (ModelNode current : resolved.asList()) {
                list.add(this.resolveExpressionsRecursively(current));
            }
            resolved = list;
        } else if (node.getType() == ModelType.PROPERTY) {
            resolved = node.clone();
            resolved.set(resolved.asProperty().getName(), this.resolveExpressionsRecursively(resolved.asProperty().getValue()));
        } else {
            resolved = node;
        }
        return resolved;
    }

    protected void resolvePluggableExpression(ModelNode node) {
        node.set(TransformerExpressionResolver.replaceProperties(node.asString(), this.properties, this.environment));
    }

    private static String replaceProperties(String value, Map<String, String> systemProperties, Map<String, String> env) {
        StringBuilder builder = new StringBuilder();
        int len = value.length();
        int state = 0;
        int start = -1;
        int nameStart = -1;
        String resolvedValue = null;
        int i = 0;
        while (i < len) {
            int ch = value.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 36: {
                            builder.appendCodePoint(ch);
                            state = 0;
                            break block0;
                        }
                        case 123: {
                            nameStart = start = i + 1;
                            state = 2;
                            break block0;
                        }
                    }
                    builder.append('$').appendCodePoint(ch);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 44: 
                        case 58: 
                        case 125: {
                            String name = value.substring(nameStart, i).trim();
                            if ("/".equals(name)) {
                                builder.append(File.separator);
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            if (":".equals(name)) {
                                builder.append(File.pathSeparator);
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            String val = systemProperties.get(name);
                            if (val == null && name.startsWith("env.")) {
                                val = env.get(name.substring(4));
                            }
                            if (val != null) {
                                builder.append(val);
                                resolvedValue = val;
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            if (ch == 44) {
                                nameStart = i + 1;
                                break block0;
                            }
                            if (ch == 58) {
                                start = i + 1;
                                state = 4;
                                break block0;
                            }
                            throw new IllegalStateException("Failed to resolve expression: " + value.substring(start - 2, i + 1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (ch != 125) break;
                    state = 0;
                    break;
                }
                case 4: {
                    if (ch != 125) break;
                    state = 0;
                    builder.append(value.substring(start, i));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected char seen: " + ch);
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        switch (state) {
            case 1: {
                builder.append('$');
                break;
            }
            case 4: {
                builder.append(value.substring(start - 2));
                break;
            }
            case 2: {
                if (resolvedValue != null) break;
                throw new IllegalStateException("Incomplete expression: " + builder.toString());
            }
        }
        return builder.toString();
    }
}

