/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.message.impl;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.CompositeWritableBuffer;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.MessageError;
import org.apache.qpid.proton.message.MessageFormat;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.apache.qpid.proton.message.impl.AMQPMessageFormat;

public class MessageImpl
implements ProtonJMessage {
    private final AMQPMessageFormat _parser = new AMQPMessageFormat();
    private Header _header;
    private DeliveryAnnotations _deliveryAnnotations;
    private MessageAnnotations _messageAnnotations;
    private Properties _properties;
    private ApplicationProperties _applicationProperties;
    private Section _body;
    private Footer _footer;
    private MessageFormat _format = MessageFormat.DATA;

    @Deprecated
    public MessageImpl() {
    }

    @Deprecated
    public MessageImpl(Header header, DeliveryAnnotations deliveryAnnotations, MessageAnnotations messageAnnotations, Properties properties, ApplicationProperties applicationProperties, Section body, Footer footer) {
        this._header = header;
        this._deliveryAnnotations = deliveryAnnotations;
        this._messageAnnotations = messageAnnotations;
        this._properties = properties;
        this._applicationProperties = applicationProperties;
        this._body = body;
        this._footer = footer;
    }

    public boolean isDurable() {
        return this._header == null || this._header.getDurable() == null ? false : this._header.getDurable();
    }

    public long getDeliveryCount() {
        return this._header == null || this._header.getDeliveryCount() == null ? 0L : this._header.getDeliveryCount().longValue();
    }

    public short getPriority() {
        return this._header == null || this._header.getPriority() == null ? (short)4 : this._header.getPriority().shortValue();
    }

    public boolean isFirstAcquirer() {
        return this._header == null || this._header.getFirstAcquirer() == null ? false : this._header.getFirstAcquirer();
    }

    public long getTtl() {
        return this._header == null || this._header.getTtl() == null ? 0L : this._header.getTtl().longValue();
    }

    public void setDurable(boolean durable) {
        if (this._header == null) {
            if (durable) {
                this._header = new Header();
            } else {
                return;
            }
        }
        this._header.setDurable(Boolean.valueOf(durable));
    }

    public void setTtl(long ttl) {
        if (this._header == null) {
            if (ttl != 0L) {
                this._header = new Header();
            } else {
                return;
            }
        }
        this._header.setTtl(UnsignedInteger.valueOf((long)ttl));
    }

    public void setDeliveryCount(long deliveryCount) {
        if (this._header == null) {
            if (deliveryCount == 0L) {
                return;
            }
            this._header = new Header();
        }
        this._header.setDeliveryCount(UnsignedInteger.valueOf((long)deliveryCount));
    }

    public void setFirstAcquirer(boolean firstAcquirer) {
        if (this._header == null) {
            if (!firstAcquirer) {
                return;
            }
            this._header = new Header();
        }
        this._header.setFirstAcquirer(Boolean.valueOf(firstAcquirer));
    }

    public void setPriority(short priority) {
        if (this._header == null) {
            if (priority == 4) {
                return;
            }
            this._header = new Header();
        }
        this._header.setPriority(UnsignedByte.valueOf((byte)((byte)priority)));
    }

    public Object getMessageId() {
        return this._properties == null ? null : this._properties.getMessageId();
    }

    public long getGroupSequence() {
        return this._properties == null || this._properties.getGroupSequence() == null ? 0L : (long)this._properties.getGroupSequence().intValue();
    }

    public String getReplyToGroupId() {
        return this._properties == null ? null : this._properties.getReplyToGroupId();
    }

    public long getCreationTime() {
        return this._properties == null || this._properties.getCreationTime() == null ? 0L : this._properties.getCreationTime().getTime();
    }

    public String getAddress() {
        return this._properties == null ? null : this._properties.getTo();
    }

    public byte[] getUserId() {
        if (this._properties == null || this._properties.getUserId() == null) {
            return null;
        }
        Binary userId = this._properties.getUserId();
        byte[] id = new byte[userId.getLength()];
        System.arraycopy(userId.getArray(), userId.getArrayOffset(), id, 0, userId.getLength());
        return id;
    }

    public String getReplyTo() {
        return this._properties == null ? null : this._properties.getReplyTo();
    }

    public String getGroupId() {
        return this._properties == null ? null : this._properties.getGroupId();
    }

    public String getContentType() {
        return this._properties == null || this._properties.getContentType() == null ? null : this._properties.getContentType().toString();
    }

    public long getExpiryTime() {
        return this._properties == null || this._properties.getAbsoluteExpiryTime() == null ? 0L : this._properties.getAbsoluteExpiryTime().getTime();
    }

    public Object getCorrelationId() {
        return this._properties == null ? null : this._properties.getCorrelationId();
    }

    public String getContentEncoding() {
        return this._properties == null || this._properties.getContentEncoding() == null ? null : this._properties.getContentEncoding().toString();
    }

    public String getSubject() {
        return this._properties == null ? null : this._properties.getSubject();
    }

    public void setGroupSequence(long groupSequence) {
        if (this._properties == null) {
            if (groupSequence == 0L) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setGroupSequence(UnsignedInteger.valueOf((int)((int)groupSequence)));
    }

    public void setUserId(byte[] userId) {
        if (userId == null) {
            if (this._properties != null) {
                this._properties.setUserId(null);
            }
        } else {
            if (this._properties == null) {
                this._properties = new Properties();
            }
            byte[] id = new byte[userId.length];
            System.arraycopy(userId, 0, id, 0, userId.length);
            this._properties.setUserId(new Binary(id));
        }
    }

    public void setCreationTime(long creationTime) {
        if (this._properties == null) {
            if (creationTime == 0L) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setCreationTime(new Date(creationTime));
    }

    public void setSubject(String subject) {
        if (this._properties == null) {
            if (subject == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setSubject(subject);
    }

    public void setGroupId(String groupId) {
        if (this._properties == null) {
            if (groupId == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setGroupId(groupId);
    }

    public void setAddress(String to) {
        if (this._properties == null) {
            if (to == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setTo(to);
    }

    public void setExpiryTime(long absoluteExpiryTime) {
        if (this._properties == null) {
            if (absoluteExpiryTime == 0L) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setAbsoluteExpiryTime(new Date(absoluteExpiryTime));
    }

    public void setReplyToGroupId(String replyToGroupId) {
        if (this._properties == null) {
            if (replyToGroupId == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setReplyToGroupId(replyToGroupId);
    }

    public void setContentEncoding(String contentEncoding) {
        if (this._properties == null) {
            if (contentEncoding == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setContentEncoding(Symbol.valueOf((String)contentEncoding));
    }

    public void setContentType(String contentType) {
        if (this._properties == null) {
            if (contentType == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setContentType(Symbol.valueOf((String)contentType));
    }

    public void setReplyTo(String replyTo) {
        if (this._properties == null) {
            if (replyTo == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setReplyTo(replyTo);
    }

    public void setCorrelationId(Object correlationId) {
        if (this._properties == null) {
            if (correlationId == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setCorrelationId(correlationId);
    }

    public void setMessageId(Object messageId) {
        if (this._properties == null) {
            if (messageId == null) {
                return;
            }
            this._properties = new Properties();
        }
        this._properties.setMessageId(messageId);
    }

    public Header getHeader() {
        return this._header;
    }

    public DeliveryAnnotations getDeliveryAnnotations() {
        return this._deliveryAnnotations;
    }

    public MessageAnnotations getMessageAnnotations() {
        return this._messageAnnotations;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public ApplicationProperties getApplicationProperties() {
        return this._applicationProperties;
    }

    public Section getBody() {
        return this._body;
    }

    public Footer getFooter() {
        return this._footer;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public void setDeliveryAnnotations(DeliveryAnnotations deliveryAnnotations) {
        this._deliveryAnnotations = deliveryAnnotations;
    }

    public void setMessageAnnotations(MessageAnnotations messageAnnotations) {
        this._messageAnnotations = messageAnnotations;
    }

    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this._applicationProperties = applicationProperties;
    }

    public void setBody(Section body) {
        this._body = body;
    }

    public void setFooter(Footer footer) {
        this._footer = footer;
    }

    public int decode(byte[] data, int offset, int length) {
        DecoderImpl decoder = new DecoderImpl();
        EncoderImpl encoder = new EncoderImpl(decoder);
        AMQPDefinedTypes.registerAllTypes(decoder, encoder);
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, length);
        decoder.setByteBuffer(buffer);
        this._header = null;
        this._deliveryAnnotations = null;
        this._messageAnnotations = null;
        this._properties = null;
        this._applicationProperties = null;
        this._body = null;
        this._footer = null;
        Object section = null;
        if (buffer.hasRemaining()) {
            section = (Section)decoder.readObject();
        }
        if (section instanceof Header) {
            this._header = (Header)section;
            section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof DeliveryAnnotations) {
            this._deliveryAnnotations = (DeliveryAnnotations)section;
            section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof MessageAnnotations) {
            this._messageAnnotations = (MessageAnnotations)section;
            section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof Properties) {
            this._properties = (Properties)section;
            section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof ApplicationProperties) {
            this._applicationProperties = (ApplicationProperties)section;
            section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section != null && !(section instanceof Footer)) {
            this._body = section;
            section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof Footer) {
            this._footer = (Footer)section;
        }
        return length - buffer.remaining();
    }

    public int encode(byte[] data, int offset, int length) {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, length);
        return this.encode(new WritableBuffer.ByteBufferWrapper(buffer));
    }

    @Override
    public int encode2(byte[] data, int offset, int length) {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, length);
        WritableBuffer.ByteBufferWrapper first = new WritableBuffer.ByteBufferWrapper(buffer);
        DroppingWritableBuffer second = new DroppingWritableBuffer();
        CompositeWritableBuffer composite = new CompositeWritableBuffer(first, second);
        int start = composite.position();
        this.encode(composite);
        return composite.position() - start;
    }

    @Override
    public int encode(WritableBuffer buffer) {
        int length = buffer.remaining();
        DecoderImpl decoder = new DecoderImpl();
        EncoderImpl encoder = new EncoderImpl(decoder);
        AMQPDefinedTypes.registerAllTypes(decoder, encoder);
        encoder.setByteBuffer(buffer);
        if (this.getHeader() != null) {
            encoder.writeObject(this.getHeader());
        }
        if (this.getDeliveryAnnotations() != null) {
            encoder.writeObject(this.getDeliveryAnnotations());
        }
        if (this.getMessageAnnotations() != null) {
            encoder.writeObject(this.getMessageAnnotations());
        }
        if (this.getProperties() != null) {
            encoder.writeObject(this.getProperties());
        }
        if (this.getApplicationProperties() != null) {
            encoder.writeObject(this.getApplicationProperties());
        }
        if (this.getBody() != null) {
            encoder.writeObject(this.getBody());
        }
        if (this.getFooter() != null) {
            encoder.writeObject(this.getFooter());
        }
        return length - buffer.remaining();
    }

    public void load(Object data) {
        switch (this._format) {
            case DATA: {
                Binary binData;
                if (data instanceof byte[]) {
                    binData = new Binary((byte[])data);
                } else if (data instanceof Binary) {
                    binData = (Binary)data;
                } else if (data instanceof String) {
                    String strData = (String)data;
                    byte[] bin = new byte[strData.length()];
                    for (int i = 0; i < bin.length; ++i) {
                        bin[i] = (byte)strData.charAt(i);
                    }
                    binData = new Binary(bin);
                } else {
                    binData = null;
                }
                this._body = new Data(binData);
                break;
            }
            case TEXT: {
                this._body = new AmqpValue((Object)(data == null ? "" : data.toString()));
                break;
            }
            default: {
                this._body = new AmqpValue(this.parseAMQPFormat((String)data));
            }
        }
    }

    public Object save() {
        switch (this._format) {
            case DATA: {
                if (this._body instanceof Data) {
                    return ((Data)this._body).getValue().getArray();
                }
                return null;
            }
            case AMQP: {
                if (this._body instanceof AmqpValue) {
                    return this.toAMQPFormat(((AmqpValue)this._body).getValue());
                }
                return null;
            }
            case TEXT: {
                if (this._body instanceof AmqpValue) {
                    Object value = ((AmqpValue)this._body).getValue();
                    return value == null ? "" : value.toString();
                }
                return null;
            }
        }
        return null;
    }

    public String toAMQPFormat(Object value) {
        return this._parser.encode(value);
    }

    public Object parseAMQPFormat(String value) {
        Object obj = this._parser.format(value);
        return obj;
    }

    public void setMessageFormat(MessageFormat format) {
        this._format = format;
    }

    public MessageFormat getMessageFormat() {
        return this._format;
    }

    public void clear() {
        this._body = null;
    }

    public MessageError getError() {
        return MessageError.OK;
    }
}

