/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import java.util.Collections;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.as.jsr77.JSR77Messages;
import org.jboss.as.jsr77.managedobject.BaseHandler;
import org.jboss.as.jsr77.managedobject.JVMHandler;
import org.jboss.as.jsr77.managedobject.ModelReader;
import org.jboss.as.jsr77.managedobject.ObjectNameBuilder;
import org.jboss.as.version.Version;

class J2EEServerHandler
extends BaseHandler {
    static final J2EEServerHandler INSTANCE = new J2EEServerHandler();
    private static final String ATTR_DEPLOYED_OBJECTS = "deployedObjects";
    private static final String ATTR_RESOURCES = "resources";
    private static final String ATTR_JAVA_VMS = "javaVMs";
    private static final String ATTR_SERVER_VENDOR = "serverVendor";
    private static final String ATTR_SERVER_VERSION = "serverVersion";
    static final String J2EE_TYPE = "J2EEServer";
    static final String DEFAULT_SERVER_TYPE = "default";
    private final String objectName;

    private J2EEServerHandler() {
        ObjectNameBuilder builder = ObjectNameBuilder.createPlain(J2EE_TYPE, DEFAULT_SERVER_TYPE);
        this.objectName = builder.toString();
    }

    @Override
    Set<ObjectName> queryObjectNames(ModelReader reader, ObjectName name, QueryExp query) {
        return Collections.singleton(ObjectNameBuilder.createObjectName(this.objectName));
    }

    String getObjectName() {
        return this.objectName;
    }

    @Override
    protected Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
        if (attribute.equals(ATTR_DEPLOYED_OBJECTS)) {
            return new String[0];
        }
        if (attribute.equals(ATTR_RESOURCES)) {
            return new String[0];
        }
        if (attribute.equals(ATTR_JAVA_VMS)) {
            return new String[]{JVMHandler.INSTANCE.getObjectName()};
        }
        if (attribute.equals(ATTR_SERVER_VENDOR)) {
            return "JBoss";
        }
        if (attribute.equals(ATTR_SERVER_VERSION)) {
            return Version.AS_VERSION;
        }
        return super.getAttribute(reader, name, attribute);
    }

    @Override
    Set<MBeanAttributeInfo> getAttributeInfos() {
        Set<MBeanAttributeInfo> attributes = super.getAttributeInfos();
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_DEPLOYED_OBJECTS, String[].class.getName(), JSR77Messages.MESSAGES.attrInfoDeployedObjects()));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_RESOURCES, String[].class.getName(), JSR77Messages.MESSAGES.attrInfoResources()));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_JAVA_VMS, String[].class.getName(), JSR77Messages.MESSAGES.attrInfoJavaVms()));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_SERVER_VENDOR, String.class.getName(), JSR77Messages.MESSAGES.attrInfoServerVendor()));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_SERVER_VERSION, String.class.getName(), JSR77Messages.MESSAGES.attrInfoServerVersion()));
        return attributes;
    }
}

