/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.logging.Log;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.util.logging.LogFactory;

final class DirectoryLoaderAdaptor {
    private static final Log log = (Log)LogFactory.getLog(DirectoryLoaderAdaptor.class, Log.class);
    private final Directory directory;
    private final LoadVisitor loadVisitor = new LoadVisitor();
    private final ContainsKeyVisitor containsKeyVisitor = new ContainsKeyVisitor();
    private final String indexName;
    private final int autoChunkSize;

    protected DirectoryLoaderAdaptor(Directory directory, String indexName, int autoChunkSize) {
        this.directory = directory;
        this.indexName = indexName;
        this.autoChunkSize = autoChunkSize;
    }

    protected void loadAllEntries(HashSet<MarshalledEntry> entriesCollector, int maxEntries, StreamingMarshaller marshaller) {
        int existingElements = entriesCollector.size();
        int toLoadElements = maxEntries - existingElements;
        if (toLoadElements <= 0) {
            return;
        }
        HashSet<IndexScopedKey> keysCollector = new HashSet<IndexScopedKey>();
        this.loadSomeKeys(keysCollector, Collections.EMPTY_SET, toLoadElements);
        for (IndexScopedKey key : keysCollector) {
            Object value = this.load(key);
            if (value == null) continue;
            MarshalledEntryImpl cacheEntry = new MarshalledEntryImpl((Object)key, value, null, marshaller);
            entriesCollector.add((MarshalledEntry)cacheEntry);
        }
    }

    private void loadSomeKeys(HashSet<IndexScopedKey> keysCollector, Set<IndexScopedKey> keysToExclude, int maxElements) {
        if (maxElements <= 0) {
            return;
        }
        int collectedKeys = 0;
        FileListCacheKey rootKey = new FileListCacheKey(this.indexName);
        if ((keysToExclude == null || !keysToExclude.contains(rootKey)) && keysCollector.add(rootKey)) {
            ++collectedKeys;
        }
        try {
            String[] listAll;
            for (String fileName : listAll = this.directory.listAll()) {
                if (collectedKeys >= maxElements) {
                    return;
                }
                FileCacheKey key = new FileCacheKey(this.indexName, fileName);
                if (keysToExclude != null && keysToExclude.contains(key) || !keysCollector.add(key) || ++collectedKeys < maxElements) continue;
                return;
            }
            for (String fileName : listAll) {
                int numChunksInt = this.figureChunksNumber(fileName);
                for (int i = 0; i < numChunksInt; ++i) {
                    ChunkCacheKey key = new ChunkCacheKey(this.indexName, fileName, i, this.autoChunkSize);
                    if (keysToExclude != null && keysToExclude.contains(key) || !keysCollector.add(key) || ++collectedKeys < maxElements) continue;
                    return;
                }
            }
        }
        catch (IOException e) {
            throw log.exceptionInCacheLoader(e);
        }
    }

    private int figureChunksNumber(String fileName) throws IOException {
        long fileLength = this.directory.fileLength(fileName);
        return DirectoryLoaderAdaptor.figureChunksNumber(fileName, fileLength, this.autoChunkSize);
    }

    public static int figureChunksNumber(String fileName, long fileLength, int chunkSize) {
        long numChunks;
        if (chunkSize < 0) {
            throw new IllegalStateException("Overflow in rescaling chunkSize. File way too large?");
        }
        long l = numChunks = fileLength % (long)chunkSize == 0L ? fileLength / (long)chunkSize : fileLength / (long)chunkSize + 1L;
        if (numChunks > Integer.MAX_VALUE) {
            log.rescalingChunksize(fileName, fileLength, chunkSize);
            chunkSize = 32 * chunkSize;
            return DirectoryLoaderAdaptor.figureChunksNumber(fileName, fileLength, chunkSize);
        }
        return (int)numChunks;
    }

    protected void close() {
        try {
            this.directory.close();
        }
        catch (IOException e) {
            log.errorOnFSDirectoryClose(e);
        }
    }

    protected Object load(IndexScopedKey key) {
        try {
            return key.accept(this.loadVisitor);
        }
        catch (Exception e) {
            throw log.exceptionInCacheLoader(e);
        }
    }

    protected boolean containsKey(IndexScopedKey key) {
        try {
            return key.accept(this.containsKeyVisitor);
        }
        catch (Exception e) {
            throw log.exceptionInCacheLoader(e);
        }
    }

    private Object loadIntern() throws IOException {
        String[] listAll = this.directory.listAll();
        return new FileListCacheValue(listAll);
    }

    private FileMetadata loadIntern(FileCacheKey key) throws IOException {
        String fileName = key.getFileName();
        long fileLength = this.directory.fileLength(fileName);
        int bufferSize = (int)Math.min(fileLength, (long)this.autoChunkSize);
        FileMetadata meta = new FileMetadata(bufferSize);
        meta.setSize(fileLength);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadIntern(ChunkCacheKey key) throws IOException {
        byte[] buffer;
        String fileName = key.getFileName();
        long chunkId = key.getChunkId();
        int bufferSize = key.getBufferSize();
        long seekTo = chunkId * (long)bufferSize;
        IndexInput input = this.directory.openInput(fileName, IOContext.READ);
        long length = input.length();
        try {
            if (seekTo != 0L) {
                input.seek(seekTo);
            }
            bufferSize = (int)Math.min(length - seekTo, (long)bufferSize);
            buffer = new byte[bufferSize];
            input.readBytes(buffer, 0, bufferSize);
        }
        finally {
            input.close();
        }
        return buffer;
    }

    private Boolean containsKeyIntern(ChunkCacheKey chunkCacheKey) throws IOException {
        try {
            long length = this.directory.fileLength(chunkCacheKey.getFileName());
            int bufferSize = chunkCacheKey.getBufferSize();
            int chunkId = chunkCacheKey.getChunkId();
            return (long)(chunkId * bufferSize) < length + (long)bufferSize;
        }
        catch (FileNotFoundException nfne) {
            return Boolean.FALSE;
        }
    }

    protected Boolean containsKeyIntern(FileCacheKey fileCacheKey) throws IOException {
        return this.directory.fileExists(fileCacheKey.getFileName());
    }

    private final class ContainsKeyVisitor
    implements KeyVisitor<Boolean> {
        private ContainsKeyVisitor() {
        }

        @Override
        public Boolean visit(FileListCacheKey fileListCacheKey) throws IOException {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(ChunkCacheKey chunkCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.containsKeyIntern(chunkCacheKey);
        }

        @Override
        public Boolean visit(FileCacheKey fileCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.containsKeyIntern(fileCacheKey);
        }

        @Override
        public Boolean visit(FileReadLockKey fileReadLockKey) {
            return Boolean.FALSE;
        }
    }

    private final class LoadVisitor
    implements KeyVisitor {
        private LoadVisitor() {
        }

        public Object visit(FileListCacheKey fileListCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.loadIntern();
        }

        public Object visit(ChunkCacheKey chunkCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.loadIntern(chunkCacheKey);
        }

        public Object visit(FileCacheKey fileCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.loadIntern(fileCacheKey);
        }

        public Object visit(FileReadLockKey fileReadLockKey) {
            return null;
        }
    }
}

