/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.impl.CommandContextImpl;

public class CommandContextFactoryImpl
extends CommandContextFactory {
    @Override
    public CommandContext newCommandContext() throws CliInitializationException {
        return new CommandContextImpl();
    }

    @Override
    public CommandContext newCommandContext(String username, char[] password) throws CliInitializationException {
        return new CommandContextImpl(username, password, username != null);
    }

    @Override
    public CommandContext newCommandContext(String controller, String username, char[] password) throws CliInitializationException {
        return this.newCommandContext(controller, username, password, false, -1);
    }

    @Override
    public CommandContext newCommandContext(String controller, String username, char[] password, boolean initConsole, int connectionTimeout) throws CliInitializationException {
        return new CommandContextImpl(controller, username, password, username != null, initConsole, connectionTimeout);
    }

    @Override
    public CommandContext newCommandContext(String controller, String username, char[] password, InputStream consoleInput, OutputStream consoleOutput) throws CliInitializationException {
        return new CommandContextImpl(controller, username, password, username != null, consoleInput, consoleOutput);
    }

    @Override
    public CommandContext newCommandContext(String controller, String username, char[] password, boolean disableLocalAuth, boolean initConsole, int connectionTimeout) throws CliInitializationException {
        return new CommandContextImpl(controller, username, password, disableLocalAuth || username != null, initConsole, connectionTimeout);
    }

    @Override
    @Deprecated
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password) throws CliInitializationException {
        try {
            return this.newCommandContext(new URI(null, null, controllerHost, controllerPort, null, null, null).toString().substring(2), username, password);
        }
        catch (URISyntaxException e) {
            throw new CliInitializationException("Unable to construct URI for connection.", e);
        }
    }

    @Override
    @Deprecated
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password, boolean initConsole, int connectionTimeout) throws CliInitializationException {
        try {
            return this.newCommandContext(new URI(null, null, controllerHost, controllerPort, null, null, null).toString().substring(2), username, password, initConsole, connectionTimeout);
        }
        catch (URISyntaxException e) {
            throw new CliInitializationException("Unable to construct URI for connection.", e);
        }
    }

    @Override
    @Deprecated
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password, InputStream consoleInput, OutputStream consoleOutput) throws CliInitializationException {
        try {
            return this.newCommandContext(new URI(null, null, controllerHost, controllerPort, null, null, null).toString().substring(2), username, password, consoleInput, consoleOutput);
        }
        catch (URISyntaxException e) {
            throw new CliInitializationException("Unable to construct URI for connection.", e);
        }
    }
}

