/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.mod_cluster.ModClusterAddProxy;
import org.wildfly.extension.mod_cluster.ModClusterDisable;
import org.wildfly.extension.mod_cluster.ModClusterDisableContext;
import org.wildfly.extension.mod_cluster.ModClusterEnable;
import org.wildfly.extension.mod_cluster.ModClusterEnableContext;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterGetProxyConfiguration;
import org.wildfly.extension.mod_cluster.ModClusterGetProxyInfo;
import org.wildfly.extension.mod_cluster.ModClusterListProxies;
import org.wildfly.extension.mod_cluster.ModClusterRefresh;
import org.wildfly.extension.mod_cluster.ModClusterRemoveProxy;
import org.wildfly.extension.mod_cluster.ModClusterReset;
import org.wildfly.extension.mod_cluster.ModClusterStop;
import org.wildfly.extension.mod_cluster.ModClusterStopContext;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemAdd;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemRemove;

public class ModClusterDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition PORT = SimpleAttributeDefinitionBuilder.create((String)"port", (ModelType)ModelType.INT, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().build();
    public static final SimpleAttributeDefinition HOST = SimpleAttributeDefinitionBuilder.create((String)"host", (ModelType)ModelType.STRING, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().build();
    public static final SimpleAttributeDefinition VIRTUAL_HOST = SimpleAttributeDefinitionBuilder.create((String)"virtualhost", (ModelType)ModelType.STRING, (boolean)false).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES).setStorageRuntime().build();
    public static final SimpleAttributeDefinition CONTEXT = SimpleAttributeDefinitionBuilder.create((String)"context", (ModelType)ModelType.STRING, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().build();
    public static final SimpleAttributeDefinition WAIT_TIME = SimpleAttributeDefinitionBuilder.create((String)"waittime", (ModelType)ModelType.INT, (boolean)true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().setDefaultValue(new ModelNode(10)).setMeasurementUnit(MeasurementUnit.SECONDS).build();
    private final boolean runtimeOnly;

    protected ModClusterDefinition(boolean runtimeOnly) {
        super(ModClusterExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)ModClusterExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)ModClusterSubsystemAdd.INSTANCE, (OperationStepHandler)ModClusterSubsystemRemove.INSTANCE);
        this.runtimeOnly = runtimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        if (this.runtimeOnly) {
            this.registerRuntimeOperations(registration);
        }
    }

    public void registerRuntimeOperations(ManagementResourceRegistration registration) {
        ResourceDescriptionResolver rootResolver = this.getResourceDescriptionResolver();
        registration.registerOperationHandler(ModClusterListProxies.getDefinition(rootResolver), (OperationStepHandler)ModClusterListProxies.INSTANCE);
        registration.registerOperationHandler(ModClusterGetProxyInfo.getDefinition(rootResolver), (OperationStepHandler)ModClusterGetProxyInfo.INSTANCE);
        registration.registerOperationHandler(ModClusterGetProxyConfiguration.getDefinition(rootResolver), (OperationStepHandler)ModClusterGetProxyConfiguration.INSTANCE);
        registration.registerOperationHandler(ModClusterAddProxy.getDefinition(rootResolver), (OperationStepHandler)ModClusterAddProxy.INSTANCE);
        registration.registerOperationHandler(ModClusterRemoveProxy.getDefinition(rootResolver), (OperationStepHandler)ModClusterRemoveProxy.INSTANCE);
        registration.registerOperationHandler(ModClusterRefresh.getDefinition(rootResolver), (OperationStepHandler)ModClusterRefresh.INSTANCE);
        registration.registerOperationHandler(ModClusterReset.getDefinition(rootResolver), (OperationStepHandler)ModClusterReset.INSTANCE);
        registration.registerOperationHandler(ModClusterEnable.getDefinition(rootResolver), (OperationStepHandler)ModClusterEnable.INSTANCE);
        registration.registerOperationHandler(ModClusterDisable.getDefinition(rootResolver), (OperationStepHandler)ModClusterDisable.INSTANCE);
        registration.registerOperationHandler(ModClusterStop.getDefinition(rootResolver), (OperationStepHandler)ModClusterStop.INSTANCE);
        registration.registerOperationHandler(ModClusterEnableContext.getDefinition(rootResolver), (OperationStepHandler)ModClusterEnableContext.INSTANCE);
        registration.registerOperationHandler(ModClusterDisableContext.getDefinition(rootResolver), (OperationStepHandler)ModClusterDisableContext.INSTANCE);
        registration.registerOperationHandler(ModClusterStopContext.getDefinition(rootResolver), (OperationStepHandler)ModClusterStopContext.INSTANCE);
    }
}

