/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.hibernate.search.util.impl.SoftLimitMRUCache;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class CachingWrapperFilter
extends Filter {
    private static final Log log = LoggerFactory.make();
    public static final int DEFAULT_SIZE = 5;
    private static final Object NULL_OBJECT = new Object();
    private final SoftLimitMRUCache cache;
    private final Filter filter;
    private static final int HARD_TO_SOFT_RATIO = 15;

    public CachingWrapperFilter(Filter filter) {
        this(filter, 5);
    }

    public CachingWrapperFilter(Filter filter, int size) {
        this.filter = filter;
        int softRefSize = size * 15;
        if (log.isDebugEnabled()) {
            log.debugf("Initialising SoftLimitMRUCache with hard ref size of %d and a soft ref of %d", size, softRefSize);
        }
        this.cache = new SoftLimitMRUCache(size, softRefSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        AtomicReader reader = context.reader();
        Object cached = this.cache.get(reader);
        if (cached != null) {
            if (cached == NULL_OBJECT) {
                return null;
            }
            return (DocIdSet)cached;
        }
        SoftLimitMRUCache softLimitMRUCache = this.cache;
        synchronized (softLimitMRUCache) {
            cached = this.cache.get(reader);
            if (cached != null) {
                if (cached == NULL_OBJECT) {
                    return null;
                }
                return (DocIdSet)cached;
            }
            DocIdSet docIdSet = this.filter.getDocIdSet(context, acceptDocs);
            if (docIdSet == null) {
                this.cache.put(reader, NULL_OBJECT);
                return null;
            }
            this.cache.put(reader, docIdSet);
            return docIdSet;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)((Object)o)).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

