/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.util;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.MessageHandler;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Map<Class<?>, Boolean> getHandlerTypes(Class<? extends MessageHandler> clazz) {
        IdentityHashMap types = new IdentityHashMap(2);
        for (Class<? extends MessageHandler> c = clazz; c != Object.class; c = c.getSuperclass()) {
            ClassUtils.exampleGenericInterfaces(types, c);
        }
        if (types.isEmpty()) {
            throw JsrWebSocketMessages.MESSAGES.unknownHandlerType(clazz);
        }
        return types;
    }

    private static void exampleGenericInterfaces(Map<Class<?>, Boolean> types, Class<?> c) {
        for (Type type : c.getGenericInterfaces()) {
            if (type instanceof ParameterizedType) {
                Class rawClass;
                Type messageType;
                ParameterizedType pt = (ParameterizedType)type;
                Type rawType = pt.getRawType();
                if (rawType == MessageHandler.Whole.class) {
                    messageType = pt.getActualTypeArguments()[0];
                    types.put((Class)messageType, Boolean.FALSE);
                    continue;
                }
                if (rawType == MessageHandler.Partial.class) {
                    messageType = pt.getActualTypeArguments()[0];
                    types.put((Class)messageType, Boolean.TRUE);
                    continue;
                }
                if (!(rawType instanceof Class) || (rawClass = (Class)rawType).getGenericInterfaces() == null) continue;
                ClassUtils.exampleGenericInterfaces(types, rawClass);
                continue;
            }
            if (!(type instanceof Class)) continue;
            ClassUtils.exampleGenericInterfaces(types, (Class)type);
        }
    }

    public static Class<?> getEncoderType(Class<? extends Encoder> clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            if (!"encode".equals(m.getName()) || m.isBridge()) continue;
            return m.getParameterTypes()[0];
        }
        throw JsrWebSocketMessages.MESSAGES.unknownEncoderType(clazz);
    }

    public static Class<?> getDecoderType(Class<? extends Decoder> clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            if (!"decode".equals(m.getName()) || m.isBridge()) continue;
            return m.getReturnType();
        }
        throw JsrWebSocketMessages.MESSAGES.couldNotDetermineDecoderTypeFor(clazz);
    }
}

