/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.driver.impl;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.DriverImpl;

class ListenerImpl<C>
implements Listener<C> {
    private final C _context;
    private final ServerSocketChannel _channel;
    private final DriverImpl _driver;
    private final Logger _logger = Logger.getLogger("proton.driver");

    ListenerImpl(DriverImpl driver, ServerSocketChannel c, C context) {
        this._driver = driver;
        this._channel = c;
        this._context = context;
    }

    public Connector<C> accept() {
        try {
            SocketChannel c = this._channel.accept();
            if (c != null) {
                c.configureBlocking(false);
                return this._driver.createServerConnector(c, this._context, this);
            }
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when accepting connection", e);
        }
        return null;
    }

    public C getContext() {
        return this._context;
    }

    public void close() throws IOException {
        this._channel.socket().close();
    }
}

