/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class ComparisonExpr
implements PrimaryPredicateExpr {
    private final ValueExpr leftChild;
    private final ValueExpr rightChild;
    private final Type comparisonType;

    public ComparisonExpr(ValueExpr leftChild, ValueExpr rightChild, Type comparisonType) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.comparisonType = comparisonType;
    }

    public ValueExpr getLeftChild() {
        return this.leftChild;
    }

    public ValueExpr getRightChild() {
        return this.rightChild;
    }

    public Type getComparisonType() {
        return this.comparisonType;
    }

    @Override
    public ValueExpr getChild() {
        return this.leftChild;
    }

    @Override
    public BooleanExpr acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpr other = (ComparisonExpr)o;
        return this.comparisonType == other.comparisonType && this.leftChild.equals(other.leftChild) && this.rightChild.equals(other.rightChild);
    }

    public int hashCode() {
        int result = 31 * this.leftChild.hashCode() + this.rightChild.hashCode();
        result = 31 * result + this.comparisonType.hashCode();
        return result;
    }

    public String toString() {
        return "ComparisonExpr{ comparisonType=" + (Object)((Object)this.comparisonType) + ", leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + '}';
    }

    public static enum Type {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER;


        public Type negate() {
            switch (this) {
                case LESS: {
                    return GREATER_OR_EQUAL;
                }
                case LESS_OR_EQUAL: {
                    return GREATER;
                }
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_OR_EQUAL;
                }
                case GREATER: {
                    return LESS;
                }
            }
            return this;
        }

        public Type reverse() {
            switch (this) {
                case LESS: {
                    return GREATER;
                }
                case GREATER: {
                    return LESS;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_OR_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_OR_EQUAL;
                }
            }
            return this;
        }
    }
}

