/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.AdminPackage.FileOpFailed;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.AdminPackage.UnknownHostName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRHostInfo;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.ImplementationRepositoryPOA;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalHostName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.RegistrationPackage.InvalidSSDRef;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.ServerStartupFailed;
import org.jacorb.imr.ServerTable;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.listener.NullTCPConnectionListener;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.IOR;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.slf4j.Logger;

public class ImplementationRepositoryImpl
extends ImplementationRepositoryPOA {
    private ORB orb;
    private Configuration configuration = null;
    private Logger logger = null;
    private String iorFile = null;
    private File table_file;
    private ServerTable server_table;
    private File table_file_backup;
    private SocketListener listener;
    private Thread listenerThread;
    private int object_activation_retries = 5;
    private int object_activation_sleep = 50;
    private boolean allow_auto_register = false;
    private boolean check_object_liveness = false;
    private long poaActivationTimeout = 120000L;
    private WriteThread wt;
    private boolean updatePending;
    private Shutdown shutdownThread;

    public ImplementationRepositoryImpl(ORB orb) {
        this.orb = orb;
        this.shutdownThread = new Shutdown();
        this.shutdownThread.setDaemon(true);
        this.shutdownThread.setName("Shutdown Thread");
        this.addShutdownHook(this.shutdownThread);
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("jacorb.imr");
        String defaultTableFile = "table.dat";
        String tableFileStr = this.configuration.getAttribute("jacorb.imr.table_file", defaultTableFile);
        if (tableFileStr == defaultTableFile && this.logger.isWarnEnabled()) {
            this.logger.warn("No file for the server table specified! Please configure the property jacorb.imr.table_file!");
            this.logger.warn("Will create \"table.dat\" in current directory, if necessary");
        }
        this.table_file = new File(tableFileStr);
        boolean _new_table = false;
        if (!this.table_file.exists()) {
            _new_table = true;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Table file " + tableFileStr + " does not exist - autocreating it.");
            }
            try {
                this.table_file.createNewFile();
            }
            catch (IOException ex) {
                throw new ConfigurationException("Failed to create table file", ex);
            }
        } else {
            if (this.table_file.isDirectory()) {
                throw new ConfigurationException("The table file is a directory! Please check " + this.table_file.getAbsolutePath());
            }
            if (!this.table_file.canRead()) {
                throw new ConfigurationException("The table file is not readable! Please check " + this.table_file.getAbsolutePath());
            }
            if (!this.table_file.canWrite()) {
                throw new ConfigurationException("The table file is not writable! Please check " + this.table_file.getAbsolutePath());
            }
        }
        try {
            if (_new_table) {
                this.server_table = new ServerTable();
                this.save_server_table(this.table_file);
            } else {
                try {
                    ObjectInputStream _in = new ObjectInputStream(new FileInputStream(this.table_file));
                    this.server_table = (ServerTable)_in.readObject();
                    _in.close();
                }
                catch (Exception ex) {
                    this.logger.warn("Failed to read ServerTable -- creating an empty one", (Throwable)ex);
                    this.server_table = new ServerTable();
                    this.save_server_table(this.table_file);
                }
            }
        }
        catch (FileOpFailed ex) {
            this.logger.error("Failed to read ServerTable", (Throwable)ex);
        }
        this.iorFile = this.configuration.getAttribute("jacorb.imr.ior_file");
        String _backup_file_str = this.configuration.getAttribute("jacorb.imr.backup_file", "");
        if (_backup_file_str.length() == 0) {
            this.logger.warn("No backup file specified!. No backup file will be created");
        }
        if (_backup_file_str.length() > 0) {
            this.table_file_backup = new File(_backup_file_str);
            if (!this.table_file_backup.exists()) {
                _new_table = true;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Backup file " + _backup_file_str + " does not exist - autocreating it.");
                }
                try {
                    this.table_file_backup.createNewFile();
                }
                catch (IOException ex) {
                    throw new ConfigurationException("Failed to create backup file", ex);
                }
            } else {
                if (this.table_file_backup.isDirectory()) {
                    throw new ConfigurationException("The backup file is a directory! Please check " + this.table_file_backup.getAbsolutePath());
                }
                if (!this.table_file_backup.canRead()) {
                    throw new ConfigurationException("The backup file is not readable! Please check " + this.table_file_backup.getAbsolutePath());
                }
                if (!this.table_file_backup.canWrite()) {
                    throw new ConfigurationException("The backup file is not writable! Please check " + this.table_file_backup.getAbsolutePath());
                }
            }
        }
        this.object_activation_retries = this.configuration.getAttributeAsInteger("jacorb.imr.object_activation_retries", 5);
        this.object_activation_sleep = this.configuration.getAttributeAsInteger("jacorb.imr.object_activation_sleep", 50);
        this.allow_auto_register = this.configuration.getAttributeAsBoolean("jacorb.imr.allow_auto_register", false);
        this.check_object_liveness = this.configuration.getAttributeAsBoolean("jacorb.imr.check_object_liveness", false);
        this.poaActivationTimeout = this.configuration.getAttributeAsInteger("jacorb.imr.timeout", 120000);
        this.listener = new SocketListener();
        this.listener.configure(this.configuration);
        this.listenerThread = new Thread(this.listener);
        this.listenerThread.setPriority(10);
        this.listenerThread.start();
        this.wt = new WriteThread();
        this.wt.setName("IMR Write Thread");
        this.wt.setDaemon(true);
        this.wt.start();
    }

    public String getIORFile() {
        return this.iorFile;
    }

    public void set_server_down(String server) throws UnknownServerName {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + server + " is going down... ");
        }
        ImRServerInfo _server = this.server_table.getServer(server);
        _server.setDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_poa(String name, String server, String host, int port) throws IllegalPOAName, DuplicatePOAName, UnknownServerName {
        ImRServerInfo _server = null;
        ImRPOAInfo _poa = null;
        boolean remap = false;
        this.updatePending = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: registering poa " + name + " for server: " + server + " on " + host + ":" + port);
        }
        if (this.allow_auto_register && !this.server_table.hasServer(server)) {
            try {
                this.register_server(server, "", "");
            }
            catch (IllegalServerName isn) {
            }
            catch (DuplicateServerName dsn) {
                // empty catch block
            }
        }
        _server = this.server_table.getServer(server);
        _poa = this.server_table.getPOA(name);
        if (_poa == null) {
            _poa = new ImRPOAInfo(name, host, port, _server, this.poaActivationTimeout);
            _server.addPOA(_poa);
            this.server_table.putPOA(name, _poa);
            this.logger.debug("ImR: new poa registered");
        } else {
            if (_poa.active || !server.equals(_poa.server.name)) {
                byte[] first = _poa.name.getBytes();
                byte[] id = new byte[first.length + 1];
                System.arraycopy(first, 0, id, 0, first.length);
                id[first.length] = 47;
                if (_poa.host.equals(host) && _poa.port == port) {
                    remap = true;
                } else {
                    boolean enp_reused = this.server_table.poa_enp_reused(_poa.name, _poa.host, _poa.port);
                    boolean bl = remap = !this.checkServerActive(_poa.host, _poa.port, id, enp_reused);
                }
                if (!remap) {
                    throw new DuplicatePOAName("POA " + name + " has already been registered " + "for server " + _poa.server.name);
                }
                this.logger.debug("ImR: Remapping server/port");
            }
            _poa.reactivate(host, port);
            this.logger.debug("ImR: register_poa, reactivated");
        }
        WriteThread writeThread = this.wt;
        synchronized (writeThread) {
            this.wt.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_host(HostInfo host) throws IllegalHostName, InvalidSSDRef {
        if (host.name == null || host.name.length() == 0) {
            throw new IllegalHostName(host.name);
        }
        try {
            host.ssd_ref.get_system_load();
        }
        catch (Exception e) {
            this.logger.error("Exception while getting system load", (Throwable)e);
            throw new InvalidSSDRef();
        }
        this.updatePending = true;
        this.server_table.putHost(host.name, new ImRHostInfo(host));
        WriteThread writeThread = this.wt;
        synchronized (writeThread) {
            this.wt.notify();
        }
    }

    public ImRInfo get_imr_info() {
        return new ImRInfo(this.listener.getAddress(), this.listener.getPort());
    }

    public HostInfo[] list_hosts() {
        return this.server_table.getHosts();
    }

    public ServerInfo[] list_servers() {
        ServerInfo[] servers;
        if (this.check_object_liveness) {
            this.logger.debug("ImR: Checking servers");
            servers = this.server_table.getServers();
            for (int k = 0; k < servers.length; ++k) {
                if (!servers[k].active || servers[k].poas.length <= 0) continue;
                byte[] first = servers[k].poas[0].name.getBytes();
                byte[] id = new byte[first.length + 1];
                System.arraycopy(first, 0, id, 0, first.length);
                id[first.length] = 47;
                if (this.checkServerActive(servers[k].poas[0].host, servers[k].poas[0].port, id, false)) continue;
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ImR: Setting server " + servers[k].name + " down");
                    }
                    this.server_table.getServer(servers[k].name).setDown();
                    servers[k].active = false;
                    continue;
                }
                catch (UnknownServerName e) {
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("ImR: Internal error - unknown server " + servers[k].name, (Throwable)e);
                }
            }
        } else {
            servers = this.server_table.getServers();
        }
        return servers;
    }

    public ServerInfo get_server_info(String server) throws UnknownServerName {
        return this.server_table.getServer(server).toServerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_server(String name, String command, String host) throws IllegalServerName, DuplicateServerName {
        this.updatePending = true;
        ImRServerInfo _server = new ImRServerInfo(name, host, command);
        this.server_table.putServer(name, _server);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + name + " on " + host + " registered");
        }
        WriteThread writeThread = this.wt;
        synchronized (writeThread) {
            this.wt.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister_server(String name) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo _server = this.server_table.getServer(name);
        String[] _poas = _server.getPOANames();
        for (int _i = 0; _i < _poas.length; ++_i) {
            this.server_table.removePOA(_poas[_i]);
        }
        this.server_table.removeServer(name);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + name + " unregistered");
        }
        WriteThread writeThread = this.wt;
        synchronized (writeThread) {
            this.wt.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit_server(String name, String command, String host) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo _server = this.server_table.getServer(name);
        _server.command = command;
        _server.host = host;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + name + " edited");
        }
        WriteThread writeThread = this.wt;
        synchronized (writeThread) {
            this.wt.notify();
        }
    }

    public void hold_server(String name) throws UnknownServerName {
        ImRServerInfo _server = this.server_table.getServer(name);
        _server.holding = true;
    }

    public void release_server(String name) throws UnknownServerName {
        ImRServerInfo _server = this.server_table.getServer(name);
        _server.release();
    }

    public void start_server(String name) throws UnknownServerName, ServerStartupFailed {
        this.restartServer(this.server_table.getServer(name));
    }

    public void save_server_table() throws FileOpFailed {
        if (this.table_file_backup != null) {
            this.save_server_table(this.table_file_backup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        Runnable runnable = this.wt;
        synchronized (runnable) {
            this.wt.shutdown();
            this.wt.notify();
        }
        if (this.listener != null) {
            this.listener.stopListening(wait);
            try {
                runnable = this.listener;
                synchronized (runnable) {
                    this.listenerThread.join(5000L);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("shutdown wait was interrupted", (Throwable)e);
            }
        }
        try {
            this.save_server_table();
        }
        catch (FileOpFailed f) {
            this.logger.error("ImR: Failed to save backup table.", (Throwable)f);
        }
        this.logger.debug("ImR: Finished shutting down");
    }

    public void unregister_host(String name) throws UnknownHostName {
        if (this.server_table.removeHost(name) == null) {
            throw new UnknownHostName(name);
        }
    }

    private void save_server_table(File save_to) throws FileOpFailed {
        try {
            ObjectOutputStream _out = new ObjectOutputStream(new FileOutputStream(save_to));
            this.server_table.table_lock.gainExclusiveLock();
            _out.writeObject(this.server_table);
            this.server_table.table_lock.releaseExclusiveLock();
            _out.flush();
            _out.close();
        }
        catch (Exception e) {
            this.logger.error("Exception while saving server table", (Throwable)e);
            throw new FileOpFailed();
        }
        this.updatePending = false;
    }

    public static void usage() {
        System.out.println("Usage: The following properties are useful in conjunction with the \nImplementationRepository:");
        System.out.println("\t \"jacorb.imr.endpoint_host\" Address to listen on for requests");
        System.out.println("\t \"jacorb.imr.endpoint_port\" Port to listen on for requests");
        System.out.println("\t \"jacorb.imr.table_file\" The file to store the server table into");
        System.out.println("\t \"jacorb.imr.backup_file\" The file to store the server table backup into");
        System.out.println("\t \"jacorb.imr.ior_file\" The file to store the ImRs IOR into");
        System.out.println("\t \"jacorb.imr.allow_auto_register\" if set to \"on\", servers that don't \n\talready have an entry on their first call to the imr, will get \n\tautomatically registered. Otherwise, an UnknownServer exception \n\tis thrown.");
        System.exit(0);
    }

    public static void main(String[] args) {
        Properties argProps = ObjectUtil.argsToProps(args);
        argProps.setProperty("jacorb.implname", "the_ImR");
        argProps.setProperty("jacorb.use_imr", "off");
        boolean printIOR = false;
        for (int i = 0; i < args.length; ++i) {
            if (!"-printIOR".equals(args[i])) continue;
            printIOR = true;
        }
        try {
            ORB orb = ORB.init(args, argProps);
            ImplementationRepositoryImpl _imr = new ImplementationRepositoryImpl(orb);
            _imr.configure(((org.jacorb.orb.ORB)orb).getConfiguration());
            POA root_poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            root_poa.the_POAManager().activate();
            Policy[] policies = new Policy[]{root_poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), root_poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            POA imr_poa = root_poa.create_POA("ImRPOA", root_poa.the_POAManager(), policies);
            for (int i = 0; i < policies.length; ++i) {
                policies[i].destroy();
            }
            byte[] id = "ImR".getBytes();
            imr_poa.activate_object_with_id(id, _imr);
            PrintWriter _out = new PrintWriter(new FileOutputStream(new File(_imr.getIORFile())));
            Object imrReference = imr_poa.servant_to_reference(_imr);
            _out.println(orb.object_to_string(imrReference));
            _out.flush();
            _out.close();
            if (printIOR) {
                System.out.println("SERVER IOR: " + orb.object_to_string(imrReference));
                System.out.flush();
            }
            orb.run();
        }
        catch (Exception _e) {
            _e.printStackTrace();
            ImplementationRepositoryImpl.usage();
            System.exit(1);
        }
    }

    private void restartServer(ImRServerInfo server) throws ServerStartupFailed {
        server.awaitRelease();
        if (!server.active) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ImR: server " + server.name + " is down");
            }
            if (server.command.length() == 0) {
                throw new ServerStartupFailed("Server " + server.name + " can't be restarted because" + " of missing startup command");
            }
            if (server.shouldBeRestarted()) {
                try {
                    ImRHostInfo _host = this.server_table.getHost(server.host);
                    if (_host == null) {
                        throw new ServerStartupFailed("Unknown host: >>" + server.host + "<<");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ImR: will restart " + server.name);
                    }
                    _host.startServer(server.command, this.orb);
                }
                catch (ServerStartupFailed ssf) {
                    server.setNotRestarting();
                    throw ssf;
                }
                catch (Exception e) {
                    server.setNotRestarting();
                    this.logger.error("Exception while restarting server", (Throwable)e);
                    this.server_table.removeHost(server.host);
                    throw new ServerStartupFailed("Failed to connect to host!");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("ImR: somebody else is restarting " + server.name);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("ImR: server " + server.name + " is active");
        }
    }

    private void addShutdownHook(Thread thread) {
        Method method = this.getHookMethod("addShutdownHook");
        if (method != null) {
            this.invokeHookMethod(method, thread);
        }
    }

    private Method getHookMethod(String name) {
        Method method = null;
        Class[] params = new Class[]{Thread.class};
        try {
            method = Runtime.class.getMethod(name, params);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return method;
    }

    private void invokeHookMethod(Method method, Thread thread) {
        block2: {
            java.lang.Object[] args = new java.lang.Object[]{thread};
            try {
                method.invoke((java.lang.Object)Runtime.getRuntime(), args);
            }
            catch (Throwable ex) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Failed to invoke Runtime." + method.getName(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkServerActive(String host, int port, byte[] object_key, boolean enp_reused) {
        ClientConnectionManager cm = null;
        IIOPAddress address = null;
        ClientConnection connection = null;
        LocateRequestOutputStream lros = null;
        LocateReplyReceiver receiver = null;
        LocateReplyInputStream lris = null;
        boolean result = false;
        cm = ((org.jacorb.orb.ORB)this.orb).getClientConnectionManager();
        try {
            address = new IIOPAddress(host, port);
            address.configure(this.configuration);
            IIOPProfile iiopProfile = new IIOPProfile(address, object_key);
            iiopProfile.configure(this.configuration);
            connection = cm.getConnection(iiopProfile);
        }
        catch (ConfigurationException e) {
            this.logger.error("Failed to configure", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Pinging " + host + " / " + port);
        }
        try {
            lros = new LocateRequestOutputStream(object_key, connection.getId(), 2);
            receiver = new LocateReplyReceiver((org.jacorb.orb.ORB)this.orb);
            connection.sendRequest(lros, receiver, lros.getRequestId(), true);
            lris = receiver.getReply();
            switch (lris.rep_hdr.locate_status.value()) {
                case 0: 
                case 4: {
                    SystemException se = SystemExceptionHelper.read(lris);
                    if (enp_reused && se instanceof OBJECT_NOT_EXIST) {
                        result = false;
                        return result;
                    } else {
                        result = true;
                        return result;
                    }
                }
                default: {
                    result = true;
                    return result;
                }
            }
        }
        catch (Throwable ex) {
            this.logger.debug("Exception while checking server active", ex);
            result = false;
            return result;
        }
        finally {
            cm.releaseConnection(connection);
        }
    }

    private class Shutdown
    extends Thread {
        private Shutdown() {
        }

        public synchronized void run() {
            ImplementationRepositoryImpl.this.logger.debug("ImR: Shutting down");
            ImplementationRepositoryImpl.this.shutdown(true);
        }
    }

    private class WriteThread
    extends Thread {
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    ImplementationRepositoryImpl.this.save_server_table(ImplementationRepositoryImpl.this.table_file);
                }
                catch (FileOpFailed ex) {
                    ImplementationRepositoryImpl.this.logger.error("Exception while saving server table", (Throwable)ex);
                }
                if (this.done) break;
                if (ImplementationRepositoryImpl.this.updatePending) continue;
                try {
                    WriteThread ex = this;
                    synchronized (ex) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ImplementationRepositoryImpl.this.logger.debug("ImR: IMR write thread waking up to save server table... ");
            }
        }

        public void shutdown() {
            this.done = true;
        }
    }

    private class ImRRequestListener
    implements RequestListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestReceived(byte[] request, GIOPConnection connection) {
            ImplementationRepositoryImpl.this.logger.debug("requestReceived");
            connection.incPendingMessages();
            RequestInputStream in = new RequestInputStream(ImplementationRepositoryImpl.this.orb, request);
            try {
                this.replyNewLocation(((org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb).mapObjectKey(ParsedIOR.extractObjectKey(in.req_hdr.target, (org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb)), in.req_hdr.request_id, in.getGIOPMinor(), connection, false);
            }
            finally {
                in.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void locateRequestReceived(byte[] request, GIOPConnection connection) {
            connection.incPendingMessages();
            LocateRequestInputStream in = new LocateRequestInputStream(ImplementationRepositoryImpl.this.orb, request);
            try {
                this.replyNewLocation(ParsedIOR.extractObjectKey(in.req_hdr.target, (org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb), in.req_hdr.request_id, in.getGIOPMinor(), connection, true);
            }
            finally {
                in.close();
            }
        }

        public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
        }

        public void fragmentReceived(byte[] fragment, GIOPConnection connection) {
        }

        public void connectionClosed() {
        }

        private void replyNewLocation(byte[] object_key, int request_id, int giop_minor, GIOPConnection connection, boolean isLocateRequest) {
            boolean ssd_valid;
            String _poa_name = POAUtil.extractImplName(object_key) + '/' + POAUtil.extractPOAName(object_key);
            ImRPOAInfo _poa = ImplementationRepositoryImpl.this.server_table.getPOA(_poa_name);
            if (_poa == null) {
                this.sendSysException(new TRANSIENT("POA " + _poa_name + " unknown"), connection, request_id, giop_minor);
                return;
            }
            ImRServerInfo _server = _poa.server;
            if (ImplementationRepositoryImpl.this.logger.isDebugEnabled()) {
                ImplementationRepositoryImpl.this.logger.debug("ImR: Looking up: " + _server.name);
            }
            boolean bl = ssd_valid = _server.command.length() != 0 && ImplementationRepositoryImpl.this.server_table.getHost(_server.host) != null;
            if (_server.active && (ImplementationRepositoryImpl.this.check_object_liveness || ssd_valid) && !ImplementationRepositoryImpl.this.checkServerActive(_poa.host, _poa.port, object_key, false)) {
                _server.setDown();
            }
            try {
                ImplementationRepositoryImpl.this.restartServer(_server);
            }
            catch (ServerStartupFailed ssf) {
                if (ImplementationRepositoryImpl.this.logger.isInfoEnabled()) {
                    ImplementationRepositoryImpl.this.logger.info("Object (" + _server.name + ") on " + _poa.host + '/' + _poa.port + " not reachable");
                }
                this.sendSysException(new TRANSIENT(ssf.reason), connection, request_id, giop_minor);
                return;
            }
            boolean _old_poa_state = _poa.active;
            if (!_poa.awaitActivation()) {
                this.sendSysException(new TRANSIENT("Timeout exceeded"), connection, request_id, giop_minor);
                return;
            }
            ReplyOutputStream out = new ReplyOutputStream((org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb, request_id, ReplyStatusType_1_2.LOCATION_FORWARD, giop_minor, isLocateRequest, ImplementationRepositoryImpl.this.logger);
            IIOPAddress addr = new IIOPAddress(_poa.host, (short)_poa.port);
            IOR _ior = null;
            try {
                addr.configure(ImplementationRepositoryImpl.this.configuration);
                IIOPProfile p = new IIOPProfile(addr, object_key, giop_minor);
                p.configure(ImplementationRepositoryImpl.this.configuration);
                _ior = ParsedIOR.createObjectIOR(p);
            }
            catch (ConfigurationException e) {
                ImplementationRepositoryImpl.this.logger.error("Error while configuring address/profile", (Throwable)e);
            }
            if (!_old_poa_state) {
                Object _object = ImplementationRepositoryImpl.this.orb.string_to_object(new ParsedIOR((org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb, _ior).getIORString());
                for (int _i = 0; _i < ImplementationRepositoryImpl.this.object_activation_retries; ++_i) {
                    try {
                        Thread.sleep(ImplementationRepositoryImpl.this.object_activation_sleep);
                        if (_object._non_existent()) continue;
                        break;
                    }
                    catch (Exception _e) {
                        ImplementationRepositoryImpl.this.logger.info("Exception while waiting for object", (Throwable)_e);
                    }
                }
            }
            try {
                out.write_IOR(_ior);
                if (ImplementationRepositoryImpl.this.logger.isDebugEnabled()) {
                    ImplementationRepositoryImpl.this.logger.debug("ImR: Sending location forward for " + _server.name);
                }
                connection.sendReply(out);
            }
            catch (IOException _e) {
                ImplementationRepositoryImpl.this.logger.error("Exception while writing new location", (Throwable)_e);
                this.sendSysException(new UNKNOWN(_e.toString()), connection, request_id, giop_minor);
            }
        }

        private void sendSysException(SystemException sys_ex, GIOPConnection connection, int request_id, int giop_minor) {
            ReplyOutputStream out = new ReplyOutputStream((org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb, request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, giop_minor, false, ImplementationRepositoryImpl.this.logger);
            SystemExceptionHelper.write(out, sys_ex);
            try {
                connection.sendReply(out);
            }
            catch (IOException _e) {
                ImplementationRepositoryImpl.this.logger.error("Exception while sending SystemException to client", (Throwable)_e);
            }
        }
    }

    private class SocketListener
    implements Runnable {
        private ServerSocket server_socket;
        private int port = 0;
        private String address;
        private int timeout = 0;
        private boolean run = true;
        private boolean wait = false;
        private MessageReceptorPool receptor_pool = null;
        private RequestListener request_listener = null;
        private ReplyListener reply_listener = null;
        private TransportManager transport_manager = null;

        public SocketListener() {
            this.request_listener = new ImRRequestListener();
            this.reply_listener = new NoBiDirServerReplyListener();
        }

        public void configure(Configuration myConfiguration) throws ConfigurationException {
            this.receptor_pool = new MessageReceptorPool("server", "ImplementationRepository", myConfiguration);
            try {
                int endpoint_port = ImplementationRepositoryImpl.this.configuration.getAttributeAsInteger("jacorb.imr.endpoint_port_number", 0);
                String endpoint_host = ImplementationRepositoryImpl.this.configuration.getAttribute("jacorb.imr.endpoint_host", "");
                this.server_socket = endpoint_host.length() > 0 ? new ServerSocket(endpoint_port, 50, InetAddress.getByName(endpoint_host)) : new ServerSocket(endpoint_port);
                this.address = endpoint_host.length() > 0 ? endpoint_host : InetAddress.getLocalHost().toString();
                if (this.address.indexOf("/") >= 0) {
                    this.address = this.address.substring(this.address.indexOf("/") + 1);
                }
                this.port = this.server_socket.getLocalPort();
                if (ImplementationRepositoryImpl.this.logger.isDebugEnabled()) {
                    ImplementationRepositoryImpl.this.logger.debug("ImR Listener at " + this.port + ", " + this.address);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Listener: Couldn't init", e);
            }
            this.transport_manager = new TransportManager((org.jacorb.orb.ORB)ImplementationRepositoryImpl.this.orb);
            this.transport_manager.configure(ImplementationRepositoryImpl.this.configuration);
        }

        public int getPort() {
            return this.port;
        }

        public String getAddress() {
            return this.address;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void run() {
            while (this.run) {
                try {
                    Socket socket = this.server_socket.accept();
                    socket.setSoTimeout(this.timeout);
                    ServerIIOPConnection transport = new ServerIIOPConnection(socket, false, new NullTCPConnectionListener());
                    transport.configure(ImplementationRepositoryImpl.this.configuration);
                    ServerGIOPConnection connection = new ServerGIOPConnection(transport.get_server_profile(), transport, this.request_listener, this.reply_listener, null, null);
                    ((GIOPConnection)connection).configure(ImplementationRepositoryImpl.this.configuration);
                    this.receptor_pool.connectionCreated(connection);
                }
                catch (Exception _e) {
                    if (!this.run) continue;
                    ImplementationRepositoryImpl.this.logger.debug("Internal Exception, can be ignored", (Throwable)_e);
                }
            }
            ImplementationRepositoryImpl.this.orb.shutdown(this.wait);
        }

        public void stopListening(boolean wait) {
            this.run = false;
            this.wait = wait;
            try {
                this.server_socket.close();
            }
            catch (Exception _e) {
                ImplementationRepositoryImpl.this.logger.error("Exception while closing server socket", (Throwable)_e);
            }
        }
    }
}

